/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.HashMap;
import org.infinispan.Cache;
import org.infinispan.xsite.AbstractTwoSitesTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"})
public abstract class BaseCacheOperationsTest
extends AbstractTwoSitesTest {
    @Test
    public void testRemove() {
        this.testRemove("LON");
        this.testRemove("NYC");
    }

    @Test
    public void testPutAndClear() {
        this.testPutAndClear("LON");
        this.testPutAndClear("NYC");
    }

    @Test
    public void testReplace() {
        this.testReplace("LON");
        this.testReplace("NYC");
    }

    @Test
    public void testPutAll() {
        this.testPutAll("LON");
        this.testPutAll("NYC");
    }

    private void testRemove(String site) {
        String key = this.key(site);
        String val = this.val(site);
        this.cache(site, 0).put((Object)key, (Object)val);
        AssertJUnit.assertEquals((Object)this.backup(site).get((Object)key), (Object)val);
        this.cache(site, 0).remove((Object)key);
        AssertJUnit.assertNull((Object)this.backup(site).get((Object)key));
        this.cache(site, 0).put((Object)key, (Object)val);
        AssertJUnit.assertEquals((Object)this.backup(site).get((Object)key), (Object)val);
        this.cache(site, 0).remove((Object)key, (Object)val);
        AssertJUnit.assertNull((Object)this.backup(site).get((Object)key));
    }

    private void testReplace(String site) {
        String key = this.key(site);
        String val = this.val(site);
        this.cache(site, 0).put((Object)key, (Object)val);
        Cache<Object, Object> backup = this.backup(site);
        AssertJUnit.assertEquals((Object)backup.get((Object)key), (Object)val);
        String val2 = val + 1;
        this.cache(site, 0).replace((Object)key, (Object)val2);
        AssertJUnit.assertEquals((Object)backup.get((Object)key), (Object)val2);
        String val3 = val + 2;
        this.cache(site, 0).replace((Object)key, (Object)"v_non", (Object)val3);
        AssertJUnit.assertEquals((Object)backup.get((Object)key), (Object)val2);
        this.cache(site, 0).replace((Object)key, (Object)val2, (Object)val3);
        AssertJUnit.assertEquals((Object)backup.get((Object)key), (Object)val3);
    }

    private void testPutAndClear(String site) {
        String key = this.key(site);
        String val = this.val(site);
        this.cache(site, 0).put((Object)key, (Object)val);
        AssertJUnit.assertEquals((Object)this.backup(site).get((Object)key), (Object)val);
        this.cache(site, 0).clear();
        AssertJUnit.assertNull((Object)this.backup(site).get((Object)(key + 1)));
        AssertJUnit.assertNull((Object)this.backup(site).get((Object)key));
    }

    private void testPutAll(String site) {
        int i;
        HashMap<String, String> all = new HashMap<String, String>();
        String key = this.key(site);
        String val = this.val(site);
        for (i = 0; i < 10; ++i) {
            all.put(key + i, val + i);
        }
        this.cache(site, 0).putAll(all);
        for (i = 0; i < 10; ++i) {
            AssertJUnit.assertEquals((Object)this.backup(site).get((Object)(key + i)), (Object)(val + i));
        }
    }
}

