/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="xsite.XSiteCacheConfigurationTest", groups={"functional, xsite"})
public class XSiteCacheConfigurationTest {
    public void testApi() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.sites().addBackup().site("LON").strategy(BackupConfiguration.BackupStrategy.SYNC).sites().addBackup().site("SFO").sites().addBackup().site("NYC");
        Assert.assertEquals((int)cb.sites().backups().size(), (int)3);
        BackupConfigurationBuilder backup0 = (BackupConfigurationBuilder)cb.sites().backups().get(0);
        Assert.assertEquals((String)backup0.site(), (String)"LON");
        Assert.assertEquals((Object)backup0.strategy(), (Object)BackupConfiguration.BackupStrategy.SYNC);
        BackupConfigurationBuilder backup1 = (BackupConfigurationBuilder)cb.sites().backups().get(1);
        Assert.assertEquals((String)backup1.site(), (String)"SFO");
        Assert.assertEquals((Object)backup1.strategy(), (Object)BackupConfiguration.BackupStrategy.ASYNC);
        BackupConfigurationBuilder backup2 = (BackupConfigurationBuilder)cb.sites().backups().get(2);
        Assert.assertEquals((String)backup2.site(), (String)"NYC");
        Assert.assertEquals((Object)backup2.strategy(), (Object)BackupConfiguration.BackupStrategy.ASYNC);
        Configuration b = cb.build();
        Assert.assertEquals((int)b.sites().allBackups().size(), (int)3);
        BackupConfiguration b0 = (BackupConfiguration)b.sites().allBackups().get(0);
        Assert.assertEquals((String)b0.site(), (String)"LON");
        Assert.assertEquals((Object)b0.strategy(), (Object)BackupConfiguration.BackupStrategy.SYNC);
        BackupConfiguration b1 = (BackupConfiguration)b.sites().allBackups().get(1);
        Assert.assertEquals((String)b1.site(), (String)"SFO");
        Assert.assertEquals((Object)b1.strategy(), (Object)BackupConfiguration.BackupStrategy.ASYNC);
        BackupConfigurationBuilder b2 = (BackupConfigurationBuilder)cb.sites().backups().get(2);
        Assert.assertEquals((String)b2.site(), (String)"NYC");
        Assert.assertEquals((Object)b2.strategy(), (Object)BackupConfiguration.BackupStrategy.ASYNC);
    }

    @Test(expectedExceptions={ConfigurationException.class})
    public void testSameBackupDefinedMultipleTimes() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.sites().addBackup().site("LON").strategy(BackupConfiguration.BackupStrategy.SYNC).sites().addBackup().site("LON").sites().addBackup().site("NYC");
        cb.build();
    }

    public void testMultipleCachesWithNoCacheName() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.sites().addBackup().site("LON").strategy(BackupConfiguration.BackupStrategy.SYNC).sites().addBackup().site("SFO").sites().addBackup().site("NYC");
        cb.build();
    }
}

