/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public class MortalCacheValue
extends ImmortalCacheValue {
    protected long created;
    protected long lifespan = -1L;

    public MortalCacheValue(Object value, long created, long lifespan) {
        super(value);
        this.created = created;
        this.lifespan = lifespan;
    }

    @Override
    public final long getCreated() {
        return this.created;
    }

    public final void setCreated(long created) {
        this.created = created;
    }

    @Override
    public final long getLifespan() {
        return this.lifespan;
    }

    public final void setLifespan(long lifespan) {
        this.lifespan = lifespan;
    }

    @Override
    public boolean isExpired(long now) {
        return ExpiryHelper.isExpiredMortal(this.lifespan, this.created, now);
    }

    @Override
    public boolean isExpired() {
        return ExpiryHelper.isExpiredMortal(this.lifespan, this.created);
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    public InternalCacheEntry toInternalCacheEntry(Object key) {
        return new MortalCacheEntry(key, this.value, this.lifespan, this.created);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MortalCacheValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MortalCacheValue that = (MortalCacheValue)o;
        if (this.created != that.created) {
            return false;
        }
        return this.lifespan == that.lifespan;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.created ^ this.created >>> 32);
        result = 31 * result + (int)(this.lifespan ^ this.lifespan >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "MortalCacheValue{value=" + this.value + ", lifespan=" + this.lifespan + ", created=" + this.created + "}";
    }

    @Override
    public MortalCacheValue clone() {
        return (MortalCacheValue)super.clone();
    }

    public static class Externalizer
    extends AbstractExternalizer<MortalCacheValue> {
        @Override
        public void writeObject(ObjectOutput output, MortalCacheValue mcv) throws IOException {
            output.writeObject(mcv.value);
            UnsignedNumeric.writeUnsignedLong(output, mcv.created);
            output.writeLong(mcv.lifespan);
        }

        @Override
        public MortalCacheValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object v = input.readObject();
            long created = UnsignedNumeric.readUnsignedLong(input);
            Long lifespan = input.readLong();
            return new MortalCacheValue(v, created, lifespan);
        }

        @Override
        public Integer getId() {
            return 15;
        }

        @Override
        public Set<Class<? extends MortalCacheValue>> getTypeClasses() {
            return Util.asSet(MortalCacheValue.class);
        }
    }
}

