/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;

public class PayloadIterator {
    protected byte[] buffer;
    protected int payloadLength;
    TermPositions tp;
    private boolean hasMore;

    public PayloadIterator(IndexReader indexReader, Term term) throws IOException {
        this(indexReader, term, new byte[1024]);
    }

    public PayloadIterator(IndexReader indexReader, Term term, byte[] buffer) throws IOException {
        this.buffer = buffer;
        this.tp = indexReader.termPositions(term);
    }

    public boolean init() throws IOException {
        this.hasMore = this.tp.next();
        return this.hasMore;
    }

    public boolean setdoc(int docId) throws IOException {
        if (!this.hasMore) {
            return false;
        }
        if (this.tp.doc() > docId) {
            return false;
        }
        if (this.tp.doc() < docId) {
            if (!this.tp.skipTo(docId)) {
                this.hasMore = false;
                return false;
            }
            if (this.tp.doc() != docId) {
                return false;
            }
        }
        this.tp.nextPosition();
        this.payloadLength = this.tp.getPayloadLength();
        if (this.payloadLength == 0) {
            return false;
        }
        if (this.payloadLength > this.buffer.length) {
            this.buffer = new byte[this.payloadLength * 2 + 1];
        }
        this.tp.getPayload(this.buffer, 0);
        return true;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getPayloadLength() {
        return this.payloadLength;
    }
}

