/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.model.geom;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.xslf.model.geom.AbsExpression;
import org.apache.poi.xslf.model.geom.AddDivideExpression;
import org.apache.poi.xslf.model.geom.AddSubtractExpression;
import org.apache.poi.xslf.model.geom.ArcTanExpression;
import org.apache.poi.xslf.model.geom.CosExpression;
import org.apache.poi.xslf.model.geom.CosineArcTanExpression;
import org.apache.poi.xslf.model.geom.Expression;
import org.apache.poi.xslf.model.geom.IfElseExpression;
import org.apache.poi.xslf.model.geom.LiteralValueExpression;
import org.apache.poi.xslf.model.geom.MaxExpression;
import org.apache.poi.xslf.model.geom.MinExpression;
import org.apache.poi.xslf.model.geom.ModExpression;
import org.apache.poi.xslf.model.geom.MultiplyDivideExpression;
import org.apache.poi.xslf.model.geom.PinExpression;
import org.apache.poi.xslf.model.geom.SinArcTanExpression;
import org.apache.poi.xslf.model.geom.SinExpression;
import org.apache.poi.xslf.model.geom.SqrtExpression;
import org.apache.poi.xslf.model.geom.TanExpression;

public class ExpressionParser {
    static final HashMap<String, Class> impls = new HashMap();

    public static Expression parse(String str) {
        for (String regexp : impls.keySet()) {
            Pattern ptrn = Pattern.compile(regexp);
            Matcher m = ptrn.matcher(str);
            if (!m.matches()) continue;
            Class c = impls.get(regexp);
            try {
                return (Expression)c.getDeclaredConstructor(Matcher.class).newInstance(m);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Unsupported formula: " + str);
    }

    static {
        impls.put("\\*/ +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", MultiplyDivideExpression.class);
        impls.put("\\+- +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)( 0)?", AddSubtractExpression.class);
        impls.put("\\+/ +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", AddDivideExpression.class);
        impls.put("\\?: +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", IfElseExpression.class);
        impls.put("val +([\\-\\w]+)", LiteralValueExpression.class);
        impls.put("abs +([\\-\\w]+)", AbsExpression.class);
        impls.put("sqrt +([\\-\\w]+)", SqrtExpression.class);
        impls.put("max +([\\-\\w]+) +([\\-\\w]+)", MaxExpression.class);
        impls.put("min +([\\-\\w]+) +([\\-\\w]+)", MinExpression.class);
        impls.put("at2 +([\\-\\w]+) +([\\-\\w]+)", ArcTanExpression.class);
        impls.put("sin +([\\-\\w]+) +([\\-\\w]+)", SinExpression.class);
        impls.put("cos +([\\-\\w]+) +([\\-\\w]+)", CosExpression.class);
        impls.put("tan +([\\-\\w]+) +([\\-\\w]+)", TanExpression.class);
        impls.put("cat2 +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", CosineArcTanExpression.class);
        impls.put("sat2 +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", SinArcTanExpression.class);
        impls.put("pin +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", PinExpression.class);
        impls.put("mod +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", ModExpression.class);
    }
}

