/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.io.Serializable;
import org.infinispan.AbstractDelegatingAdvancedCache;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.CherryPickClassLoader;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.WithClassLoaderTest")
public class WithClassLoaderTest
extends MultipleCacheManagersTest {
    private static final String BASE = WithClassLoaderTest.class.getName() + "$";
    private static final String CAR = BASE + "Car";
    protected ClassLoader systemCl;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.storeAsBinary().enable().clustering().cacheMode(CacheMode.REPL_SYNC);
        EmbeddedCacheManager cm0 = TestCacheManagerFactory.createClusteredCacheManager(builder);
        this.cacheManagers.add(cm0);
        String[] notFound = new String[]{CAR};
        this.systemCl = Thread.currentThread().getContextClassLoader();
        CherryPickClassLoader cl = new CherryPickClassLoader(null, null, notFound, this.systemCl);
        GlobalConfigurationBuilder gcBuilder = this.createSecondGlobalCfgBuilder(cl);
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager(gcBuilder, builder);
        this.cacheManagers.add(cm1);
    }

    protected GlobalConfigurationBuilder createSecondGlobalCfgBuilder(ClassLoader cl) {
        GlobalConfigurationBuilder gcBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gcBuilder.classLoader(cl);
        return gcBuilder;
    }

    public void testReadingWithCorrectClassLoaderAfterReplication() {
        this.writeReadWithCorrectClassLoader((AdvancedCache<Integer, Car>)this.cache(1).getAdvancedCache());
    }

    public void testReadingWithCorrectClassLoaderAfterReplicationWithDelegateCache() {
        AdvancedCache cache = this.advancedCache(1);
        CustomDelegateCache delegate = new CustomDelegateCache(cache);
        this.writeReadWithCorrectClassLoader((AdvancedCache<Integer, Car>)delegate);
    }

    private void writeReadWithCorrectClassLoader(AdvancedCache<Integer, Car> readWithCache) {
        Car value;
        block2: {
            AdvancedCache c0 = this.advancedCache(0);
            AdvancedCache c1 = this.advancedCache(1);
            value = new Car().plateNumber("1234");
            c0.put((Object)1, (Object)value);
            try {
                c1.get((Object)1);
                AssertJUnit.fail((String)"Expected a ClassNotFoundException");
            }
            catch (CacheException e) {
                if (e.getCause() instanceof ClassNotFoundException) break block2;
                throw e;
            }
        }
        AssertJUnit.assertEquals((Object)value, (Object)readWithCache.with(this.systemCl).get((Object)1));
    }

    public static class CustomDelegateCache<K, V>
    extends AbstractDelegatingAdvancedCache<K, V> {
        public CustomDelegateCache(AdvancedCache<K, V> cache) {
            super(cache, new AbstractDelegatingAdvancedCache.AdvancedCacheWrapper<K, V>(){

                public AdvancedCache<K, V> wrap(AdvancedCache<K, V> cache) {
                    return new CustomDelegateCache(cache);
                }
            });
        }
    }

    public static class Car
    implements Serializable {
        String plateNumber;

        public Car plateNumber(String s) {
            this.plateNumber = s;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Car car = (Car)o;
            return !(this.plateNumber == null ? car.plateNumber != null : !this.plateNumber.equals(car.plateNumber));
        }

        public int hashCode() {
            return this.plateNumber != null ? this.plateNumber.hashCode() : 0;
        }
    }
}

