/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.config.Configuration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.ValueFuture;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="atomic.AtomicHashMapConcurrencyTest")
public class AtomicHashMapConcurrencyTest
extends AbstractInfinispanTest {
    private static final Log log = LogFactory.getLog(AtomicHashMapConcurrencyTest.class);
    public static final String KEY = "key";
    Cache<String, Object> cache;
    TransactionManager tm;
    private CacheContainer cm;

    @BeforeMethod
    protected void setUp() {
        Configuration c = new Configuration();
        c.setLockAcquisitionTimeout(500L);
        c.setInvocationBatchingEnabled(true);
        c.fluent().transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).lockingMode(LockingMode.PESSIMISTIC);
        this.cm = TestCacheManagerFactory.createCacheManager(c);
        this.cache = this.cm.getCache();
        this.tm = TestingUtil.getTransactionManager(this.cache);
    }

    @AfterMethod(alwaysRun=true)
    protected void tearDown() {
        try {
            this.tm.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestingUtil.killCacheManagers(this.cm);
    }

    public void testConcurrentCreate() throws Exception {
        this.tm.begin();
        AtomicMapLookup.getAtomicMap(this.cache, (Object)KEY);
        final AtomicBoolean gotTimeoutException = new AtomicBoolean();
        this.fork(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AtomicHashMapConcurrencyTest.this.tm.begin();
                    try {
                        AtomicMapLookup.getAtomicMap(AtomicHashMapConcurrencyTest.this.cache, (Object)AtomicHashMapConcurrencyTest.KEY);
                    }
                    catch (TimeoutException e) {
                        gotTimeoutException.set(true);
                    }
                    finally {
                        AtomicHashMapConcurrencyTest.this.tm.rollback();
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Unexpected error performing transaction", (Throwable)e);
                }
            }
        }, true);
        assert (gotTimeoutException.get());
    }

    public void testConcurrentModifications() throws Exception {
        AtomicMap atomicMap = AtomicMapLookup.getAtomicMap(this.cache, (Object)KEY);
        this.tm.begin();
        atomicMap.put((Object)1, (Object)"");
        final AtomicBoolean gotTimeoutException = new AtomicBoolean();
        this.fork(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AtomicHashMapConcurrencyTest.this.tm.begin();
                    try {
                        AtomicMap otMap = AtomicMapLookup.getAtomicMap(AtomicHashMapConcurrencyTest.this.cache, (Object)AtomicHashMapConcurrencyTest.KEY);
                        otMap.put((Object)1, (Object)"val");
                    }
                    catch (TimeoutException e) {
                        gotTimeoutException.set(true);
                    }
                    finally {
                        AtomicHashMapConcurrencyTest.this.tm.rollback();
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Unexpected error performing transaction", (Throwable)e);
                }
            }
        }, true);
        assert (gotTimeoutException.get());
    }

    public void testReadAfterTxStarted() throws Exception {
        AtomicMap atomicMap = AtomicMapLookup.getAtomicMap(this.cache, (Object)KEY);
        atomicMap.put((Object)1, (Object)"existing");
        this.tm.begin();
        atomicMap.put((Object)1, (Object)"newVal");
        final ValueFuture responseBeforeCommit = new ValueFuture();
        final ValueFuture responseAfterCommit = new ValueFuture();
        final CountDownLatch commitLatch = new CountDownLatch(1);
        Thread ot = this.fork(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AtomicHashMapConcurrencyTest.this.tm.begin();
                    try {
                        AtomicMap otMap = AtomicMapLookup.getAtomicMap(AtomicHashMapConcurrencyTest.this.cache, (Object)AtomicHashMapConcurrencyTest.KEY);
                        responseBeforeCommit.set(otMap.get((Object)1));
                        commitLatch.await();
                        responseAfterCommit.set(otMap.get((Object)1));
                    }
                    finally {
                        AtomicHashMapConcurrencyTest.this.tm.rollback();
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Unexpected error performing transaction", (Throwable)e);
                }
            }
        }, false);
        Assert.assertEquals(responseBeforeCommit.get(), (Object)"existing");
        this.tm.commit();
        commitLatch.countDown();
        Assert.assertEquals((String)((String)atomicMap.get((Object)1)), (String)"newVal");
        Assert.assertEquals(responseAfterCommit.get(), (Object)"newVal");
    }
}

