/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="atomic.AtomicMapFunctionalTest")
public class AtomicMapFunctionalTest
extends AbstractInfinispanTest {
    private static final Log log = LogFactory.getLog(AtomicMapFunctionalTest.class);
    Cache<String, Object> cache;
    TransactionManager tm;
    private EmbeddedCacheManager cm;

    @BeforeMethod
    public void setUp() {
        Configuration c = new Configuration();
        c.setInvocationBatchingEnabled(true);
        this.cm = TestCacheManagerFactory.createCacheManager(c);
        this.cache = this.cm.getCache();
        this.tm = TestingUtil.getTransactionManager(this.cache);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCacheManagers(this.cm);
        this.cache = null;
        this.tm = null;
    }

    public void testChangesOnAtomicMap() {
        AtomicMap map = AtomicMapLookup.getAtomicMap(this.cache, (Object)"key");
        assert (map.isEmpty());
        map.put((Object)"a", (Object)"b");
        assert (((String)map.get((Object)"a")).equals("b"));
        assert (AtomicMapLookup.getAtomicMap(this.cache, (Object)"key").get((Object)"a").equals("b"));
    }

    public void testTxChangesOnAtomicMap() throws Exception {
        AtomicMap map = AtomicMapLookup.getAtomicMap(this.cache, (Object)"key");
        this.tm.begin();
        assert (map.isEmpty());
        map.put((Object)"a", (Object)"b");
        assert (((String)map.get((Object)"a")).equals("b"));
        Transaction t = this.tm.suspend();
        assert (AtomicMapLookup.getAtomicMap(this.cache, (Object)"key").get((Object)"a") == null);
        this.tm.resume(t);
        this.tm.commit();
        assert (AtomicMapLookup.getAtomicMap(this.cache, (Object)"key").get((Object)"a").equals("b"));
    }

    public void testChangesOnAtomicMapNoLocks() {
        AtomicMap map = AtomicMapLookup.getAtomicMap(this.cache, (Object)"key");
        assert (map.isEmpty());
        log.debug((Object)"Doing a put");
        map.put((Object)"a", (Object)"b");
        log.debug((Object)"Put complete");
        assert (((String)map.get((Object)"a")).equals("b"));
        assert (AtomicMapLookup.getAtomicMap(this.cache, (Object)"key").get((Object)"a").equals("b"));
    }

    public void testTxChangesOnAtomicMapNoLocks() throws Exception {
        AtomicMap map = AtomicMapLookup.getAtomicMap(this.cache, (Object)"key");
        this.tm.begin();
        assert (map.isEmpty());
        map.put((Object)"a", (Object)"b");
        assert (((String)map.get((Object)"a")).equals("b"));
        Transaction t = this.tm.suspend();
        assert (AtomicMapLookup.getAtomicMap(this.cache, (Object)"key").get((Object)"a") == null);
        this.tm.resume(t);
        this.tm.commit();
        assert (AtomicMapLookup.getAtomicMap(this.cache, (Object)"key").get((Object)"a").equals("b"));
    }

    public void testChangesOnAtomicMapNoLocksExistingData() {
        AtomicMap map = AtomicMapLookup.getAtomicMap(this.cache, (Object)"key");
        assert (map.isEmpty());
        map.put((Object)"x", (Object)"y");
        assert (((String)map.get((Object)"x")).equals("y"));
        log.debug((Object)"Doing a put");
        map.put((Object)"a", (Object)"b");
        log.debug((Object)"Put complete");
        assert (((String)map.get((Object)"a")).equals("b"));
        assert (((String)map.get((Object)"x")).equals("y"));
        assert (AtomicMapLookup.getAtomicMap(this.cache, (Object)"key").get((Object)"x").equals("y"));
        assert (AtomicMapLookup.getAtomicMap(this.cache, (Object)"key").get((Object)"a").equals("b"));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testRemovalOfAtomicMap() throws SystemException, NotSupportedException, RollbackException, HeuristicRollbackException, HeuristicMixedException {
        AtomicMap map = AtomicMapLookup.getAtomicMap(this.cache, (Object)"key");
        map.put((Object)"hello", (Object)"world");
        TransactionManager tm = this.cache.getAdvancedCache().getTransactionManager();
        tm.begin();
        map = AtomicMapLookup.getAtomicMap(this.cache, (Object)"key");
        map.put((Object)"hello2", (Object)"world2");
        assert (map.size() == 2);
        AtomicMapLookup.removeAtomicMap(this.cache, (Object)"key");
        map.size();
        tm.commit();
    }
}

