/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.util.Map;
import java.util.concurrent.Callable;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicHashMapProxy;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.atomic.FineGrainedAtomicHashMapProxy;
import org.infinispan.atomic.FineGrainedAtomicMap;
import org.infinispan.atomic.TestDeltaAware;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="atomic.LocalDeltaAwareEvictionTest")
@CleanupAfterMethod
public class LocalDeltaAwareEvictionTest
extends MultipleCacheManagersTest {
    protected static final String KEY1 = "key1";
    protected static final String KEY2 = "key2";
    protected boolean txEnabled = false;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder configBuilder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        configBuilder.eviction().maxEntries(1).strategy(EvictionStrategy.LRU).loaders().addStore().cacheStore((CacheStore)new DummyInMemoryCacheStore());
        this.addClusterEnabledCacheManager(configBuilder);
    }

    protected Object withTx(int cacheIndex, Callable<Object> c) throws Exception {
        if (this.txEnabled) {
            return TestingUtil.withTx(this.cache(cacheIndex).getAdvancedCache().getTransactionManager(), c);
        }
        return c.call();
    }

    protected void assertNumberOfEntries(int cacheIndex) throws Exception {
        CacheStore cacheStore = TestingUtil.extractComponent(this.cache(cacheIndex), CacheLoaderManager.class).getCacheStore();
        Assert.assertEquals((long)2L, (long)cacheStore.loadAllKeys(null).size());
        DataContainer dataContainer = this.cache(cacheIndex).getAdvancedCache().getDataContainer();
        Assert.assertEquals((long)1L, (long)dataContainer.size());
    }

    protected void test(final DeltaAwareAccessor daa, int nodeThatReads, final int nodeThatWrites) throws Exception {
        this.withTx(nodeThatWrites, new Callable<Object>(){

            @Override
            public Object call() {
                daa.createObject(LocalDeltaAwareEvictionTest.this.cache(nodeThatWrites), LocalDeltaAwareEvictionTest.KEY1);
                daa.createObject(LocalDeltaAwareEvictionTest.this.cache(nodeThatWrites), LocalDeltaAwareEvictionTest.KEY2);
                return null;
            }
        });
        this.assertInitialValues(daa, nodeThatWrites);
        if (nodeThatReads != nodeThatWrites) {
            this.assertInitialValues(daa, nodeThatReads);
        }
        this.withTx(nodeThatWrites, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Object obj1 = daa.getObject(LocalDeltaAwareEvictionTest.this.cache(nodeThatWrites), LocalDeltaAwareEvictionTest.KEY1);
                daa.setFirstComponent(obj1, "** UPDATED** first component of object with key=key1");
                daa.putObject(LocalDeltaAwareEvictionTest.this.cache(nodeThatWrites), LocalDeltaAwareEvictionTest.KEY1, obj1);
                Object obj2 = daa.getObject(LocalDeltaAwareEvictionTest.this.cache(nodeThatWrites), LocalDeltaAwareEvictionTest.KEY2);
                daa.setFirstComponent(obj2, "** UPDATED** first component of object with key=key2");
                daa.putObject(LocalDeltaAwareEvictionTest.this.cache(nodeThatWrites), LocalDeltaAwareEvictionTest.KEY2, obj2);
                return null;
            }
        });
        this.assertUpdatedValues(daa, nodeThatWrites);
        if (nodeThatReads != nodeThatWrites) {
            this.assertUpdatedValues(daa, nodeThatReads);
        }
    }

    protected void assertInitialValues(DeltaAwareAccessor daa, int cacheIndex) throws Exception {
        this.assertNumberOfEntries(cacheIndex);
        Object obj1 = daa.getObject(this.cache(cacheIndex), KEY1);
        Assert.assertNotNull(obj1);
        Assert.assertEquals((Object)"first component of object with key=key1", (Object)daa.getFirstComponent(obj1));
        Assert.assertEquals((Object)"second component of object with key=key1", (Object)daa.getSecondComponent(obj1));
        Object obj2 = daa.getObject(this.cache(cacheIndex), KEY2);
        Assert.assertNotNull(obj2);
        Assert.assertEquals((Object)"first component of object with key=key2", (Object)daa.getFirstComponent(obj2));
        Assert.assertEquals((Object)"second component of object with key=key2", (Object)daa.getSecondComponent(obj2));
        this.assertNumberOfEntries(cacheIndex);
    }

    protected void assertUpdatedValues(DeltaAwareAccessor daa, int nodeThatReads) throws Exception {
        this.assertNumberOfEntries(nodeThatReads);
        Object obj1 = daa.getObject(this.cache(nodeThatReads), KEY1);
        Assert.assertNotNull(obj1);
        Assert.assertEquals((Object)"** UPDATED** first component of object with key=key1", (Object)daa.getFirstComponent(obj1));
        Assert.assertEquals((Object)"second component of object with key=key1", (Object)daa.getSecondComponent(obj1));
        Object obj2 = daa.getObject(this.cache(nodeThatReads), KEY2);
        Assert.assertNotNull(obj2);
        Assert.assertEquals((Object)"** UPDATED** first component of object with key=key2", (Object)daa.getFirstComponent(obj2));
        Assert.assertEquals((Object)"second component of object with key=key2", (Object)daa.getSecondComponent(obj2));
        this.assertNumberOfEntries(nodeThatReads);
    }

    public void testDeltaAware() throws Exception {
        this.test(this.createDeltaAwareAccessor(), 0, 0);
    }

    protected DeltaAwareAccessor<TestDeltaAware, String> createDeltaAwareAccessor() {
        return new DeltaAwareAccessor<TestDeltaAware, String>(){

            @Override
            public TestDeltaAware createObject(Cache cache, String key) {
                TestDeltaAware da = new TestDeltaAware();
                da.setFirstComponent("first component of object with key=" + key);
                da.setSecondComponent("second component of object with key=" + key);
                cache.put((Object)key, (Object)da);
                return da;
            }

            @Override
            public TestDeltaAware getObject(Cache cache, String key) {
                return (TestDeltaAware)cache.get((Object)key);
            }

            @Override
            public void putObject(Cache cache, String key, TestDeltaAware da) {
                cache.put((Object)key, (Object)da);
            }

            @Override
            public String getFirstComponent(TestDeltaAware da) {
                return da.getFirstComponent();
            }

            @Override
            public void setFirstComponent(TestDeltaAware da, String value) {
                da.setFirstComponent(value);
            }

            @Override
            public String getSecondComponent(TestDeltaAware da) {
                return da.getSecondComponent();
            }

            @Override
            public void setSecondComponent(TestDeltaAware da, String value) {
                da.setSecondComponent(value);
            }
        };
    }

    public void testAtomicMap() throws Exception {
        this.test(this.createAtomicMapAccessor(), 0, 0);
    }

    protected DeltaAwareAccessor<Map<String, String>, String> createAtomicMapAccessor() {
        return new DeltaAwareAccessor<Map<String, String>, String>(){

            @Override
            public Map<String, String> createObject(Cache cache, String key) {
                AtomicMap map = AtomicMapLookup.getAtomicMap((Cache)cache, (Object)key);
                map.put("first", "first component of object with key=" + key);
                map.put("second", "second component of object with key=" + key);
                return map;
            }

            @Override
            public Map<String, String> getObject(Cache cache, String key) {
                return AtomicMapLookup.getAtomicMap((Cache)cache, (Object)key, (boolean)false);
            }

            @Override
            public void putObject(Cache cache, String key, Map<String, String> da) {
                Assert.assertTrue((boolean)(da instanceof AtomicHashMapProxy));
            }

            @Override
            public String getFirstComponent(Map<String, String> da) {
                return da.get("first");
            }

            @Override
            public void setFirstComponent(Map<String, String> da, String value) {
                da.put("first", value);
            }

            @Override
            public String getSecondComponent(Map<String, String> da) {
                return da.get("second");
            }

            @Override
            public void setSecondComponent(Map<String, String> da, String value) {
                da.put("second", value);
            }
        };
    }

    public void testFineGrainedAtomicMap() throws Exception {
        this.test(this.createFineGrainedAtomicMapAccessor(), 0, 0);
    }

    protected DeltaAwareAccessor<Map<String, String>, String> createFineGrainedAtomicMapAccessor() {
        return new DeltaAwareAccessor<Map<String, String>, String>(){

            @Override
            public Map<String, String> createObject(Cache cache, String key) {
                FineGrainedAtomicMap map = AtomicMapLookup.getFineGrainedAtomicMap((Cache)cache, (Object)key);
                map.put("first", "first component of object with key=" + key);
                map.put("second", "second component of object with key=" + key);
                return map;
            }

            @Override
            public Map<String, String> getObject(Cache cache, String key) {
                return AtomicMapLookup.getFineGrainedAtomicMap((Cache)cache, (Object)key, (boolean)false);
            }

            @Override
            public void putObject(Cache cache, String key, Map<String, String> da) {
                Assert.assertTrue((boolean)(da instanceof FineGrainedAtomicHashMapProxy));
            }

            @Override
            public String getFirstComponent(Map<String, String> da) {
                return da.get("first");
            }

            @Override
            public void setFirstComponent(Map<String, String> da, String value) {
                da.put("first", value);
            }

            @Override
            public String getSecondComponent(Map<String, String> da) {
                return da.get("second");
            }

            @Override
            public void setSecondComponent(Map<String, String> da, String value) {
                da.put("second", value);
            }
        };
    }

    static interface DeltaAwareAccessor<TDA, TK> {
        public TDA createObject(Cache var1, TK var2);

        public TDA getObject(Cache var1, TK var2);

        public void putObject(Cache var1, TK var2, TDA var3);

        public String getFirstComponent(TDA var1);

        public void setFirstComponent(TDA var1, String var2);

        public String getSecondComponent(TDA var1);

        public void setSecondComponent(TDA var1, String var2);
    }
}

