/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="config.ConfigurationValidationTest")
public class ConfigurationValidationTest
extends AbstractInfinispanTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={ConfigurationException.class})
    public void testWrongCacheModeConfiguration() throws Exception {
        EmbeddedCacheManager cacheManager = null;
        try {
            cacheManager = this.createCacheManager();
            cacheManager.getCache().put((Object)"key", (Object)"value");
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCacheModeConfiguration() throws Exception {
        EmbeddedCacheManager cacheManager = null;
        try {
            cacheManager = this.createCacheManager();
            cacheManager.getCache("local").put((Object)"key", (Object)"value");
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={ConfigurationException.class})
    public void testDistAndReplQueue() {
        EmbeddedCacheManager ecm = null;
        try {
            Configuration c = new Configuration();
            c.setCacheMode(Configuration.CacheMode.DIST_ASYNC);
            c.setUseReplQueue(true);
            ecm = TestCacheManagerFactory.createClusteredCacheManager(c);
            ecm.getCache();
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(ecm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(ecm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={ConfigurationException.class})
    public void testEvictionOnButWithoutMaxEntries() {
        EmbeddedCacheManager ecm = null;
        try {
            Configuration c = new Configuration();
            c.setEvictionStrategy("LRU");
            ecm = TestCacheManagerFactory.createClusteredCacheManager(c);
            ecm.getCache();
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(ecm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(ecm);
    }

    private EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfiguration gc = GlobalConfiguration.getNonClusteredDefault();
        Configuration config = new Configuration();
        config.setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(gc, config);
        config = new Configuration();
        config.setCacheMode(Configuration.CacheMode.LOCAL);
        cm.defineConfiguration("local", config);
        return cm;
    }
}

