/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import javax.transaction.TransactionManager;
import junit.framework.Assert;
import org.infinispan.config.Configuration;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.tm.DummyTransactionManager;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="config.TxManagerLookupConfigTest")
public class TxManagerLookupConfigTest {
    static TmA tma = new TmA();
    static TmB tmb = new TmB();

    public void simpleTest() {
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(new Configuration())){

            @Override
            public void call() {
                Configuration customConfiguration = TestCacheManagerFactory.getDefaultConfiguration(true);
                customConfiguration.setTransactionManagerLookup((TransactionManagerLookup)new TxManagerLookupA());
                Configuration definedConfiguration = this.cm.defineConfiguration("aCache", customConfiguration);
                Assert.assertTrue((boolean)(definedConfiguration.getTransactionManagerLookup() instanceof TxManagerLookupA));
                TransactionManager activeTransactionManager = this.cm.getCache("aCache").getAdvancedCache().getTransactionManager();
                Assert.assertNotNull((Object)activeTransactionManager);
                Assert.assertTrue((boolean)(activeTransactionManager instanceof TmA));
            }
        });
    }

    public static class TxManagerLookupB
    implements TransactionManagerLookup {
        public synchronized TransactionManager getTransactionManager() throws Exception {
            return tmb;
        }
    }

    public static class TxManagerLookupA
    implements TransactionManagerLookup {
        public synchronized TransactionManager getTransactionManager() throws Exception {
            return tma;
        }
    }

    public static class TmB
    extends DummyTransactionManager {
    }

    public static class TmA
    extends DummyTransactionManager {
    }
}

