/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="configuration.ParserOverrideTest")
public class ParserOverrideTest {
    public void testNamedCacheOverride() throws Exception {
        String cacheName = "asyncRepl";
        String xml1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.2 http://www.infinispan.org/schemas/infinispan-config-5.2.xsd\"\n      xmlns=\"urn:infinispan:config:5.2\">   <namedCache name=\"asyncRepl\">\n      <clustering mode=\"repl\">\n         <stateTransfer fetchInMemoryState=\"false\"/>\n         <async useReplQueue=\"false\" asyncMarshalling=\"false\"/>\n      </clustering>\n      <locking isolationLevel=\"REPEATABLE_READ\" concurrencyLevel=\"1000\" lockAcquisitionTimeout=\"20000\"/>\n      <storeAsBinary enabled=\"true\"/>\n      <expiration wakeUpInterval=\"23\" lifespan=\"50012\" maxIdle=\"1341\"/>\n   </namedCache>\n</infinispan>";
        String xml2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.2 http://www.infinispan.org/schemas/infinispan-config-5.2.xsd\"\n      xmlns=\"urn:infinispan:config:5.2\">   <namedCache name=\"asyncRepl\">\n      <clustering mode=\"repl\">\n         <stateTransfer fetchInMemoryState=\"true\"/>\n         <sync replTimeout=\"30000\"/>\n      </clustering>\n      <locking isolationLevel=\"READ_COMMITTED\" concurrencyLevel=\"30\" lockAcquisitionTimeout=\"25000\"/>\n      <storeAsBinary enabled=\"false\"/>\n   </namedCache>\n</infinispan>";
        ConfigurationBuilderHolder holder = TestCacheManagerFactory.buildAggregateHolder(xml1, xml2);
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createClusteredCacheManager(holder)){

            @Override
            public void call() {
                Configuration c = this.cm.getCacheConfiguration("asyncRepl");
                Assert.assertEquals((Object)c.clustering().cacheMode(), (Object)CacheMode.REPL_SYNC);
                Assert.assertEquals((boolean)c.clustering().stateTransfer().fetchInMemoryState(), (boolean)true);
                Assert.assertEquals((long)c.clustering().sync().replTimeout(), (long)30000L);
                Assert.assertEquals((Object)c.locking().isolationLevel(), (Object)IsolationLevel.READ_COMMITTED);
                Assert.assertEquals((int)c.locking().concurrencyLevel(), (int)30);
                Assert.assertEquals((long)c.locking().lockAcquisitionTimeout(), (long)25000L);
                Assert.assertEquals((boolean)c.storeAsBinary().enabled(), (boolean)false);
                Assert.assertEquals((long)c.expiration().wakeUpInterval(), (long)23L);
                Assert.assertEquals((long)c.expiration().lifespan(), (long)50012L);
                Assert.assertEquals((long)c.expiration().maxIdle(), (long)1341L);
            }
        });
    }

    public void testDefaultCacheOverride() throws Exception {
        String xml1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.2 http://www.infinispan.org/schemas/infinispan-config-5.2.xsd\"\n      xmlns=\"urn:infinispan:config:5.2\">   <default>\n      <clustering mode=\"repl\">\n         <stateTransfer fetchInMemoryState=\"false\"/>\n         <async useReplQueue=\"false\" asyncMarshalling=\"false\"/>\n      </clustering>\n      <locking isolationLevel=\"REPEATABLE_READ\" concurrencyLevel=\"1000\" lockAcquisitionTimeout=\"20000\"/>\n      <storeAsBinary enabled=\"true\"/>\n      <expiration wakeUpInterval=\"23\" lifespan=\"50012\" maxIdle=\"1341\"/>\n      <jmxStatistics enabled=\"true\"/>\n   </default>\n</infinispan>";
        String xml2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.2 http://www.infinispan.org/schemas/infinispan-config-5.2.xsd\"\n      xmlns=\"urn:infinispan:config:5.2\">   <default>\n      <clustering mode=\"repl\">\n         <stateTransfer fetchInMemoryState=\"true\"/>\n         <sync replTimeout=\"30000\"/>\n      </clustering>\n      <locking isolationLevel=\"READ_COMMITTED\" concurrencyLevel=\"30\" lockAcquisitionTimeout=\"25000\"/>\n      <storeAsBinary enabled=\"false\"/>\n   </default>\n</infinispan>";
        ConfigurationBuilderHolder holder = TestCacheManagerFactory.buildAggregateHolder(xml1, xml2);
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createClusteredCacheManager(holder)){

            @Override
            public void call() {
                Configuration c = this.cm.getDefaultCacheConfiguration();
                Assert.assertEquals((Object)c.clustering().cacheMode(), (Object)CacheMode.REPL_SYNC);
                Assert.assertEquals((boolean)c.clustering().stateTransfer().fetchInMemoryState(), (boolean)true);
                Assert.assertEquals((long)c.clustering().sync().replTimeout(), (long)30000L);
                Assert.assertEquals((Object)c.locking().isolationLevel(), (Object)IsolationLevel.READ_COMMITTED);
                Assert.assertEquals((int)c.locking().concurrencyLevel(), (int)30);
                Assert.assertEquals((long)c.locking().lockAcquisitionTimeout(), (long)25000L);
                Assert.assertEquals((boolean)c.storeAsBinary().enabled(), (boolean)false);
                Assert.assertEquals((long)c.expiration().wakeUpInterval(), (long)23L);
                Assert.assertEquals((long)c.expiration().lifespan(), (long)50012L);
                Assert.assertEquals((long)c.expiration().maxIdle(), (long)1341L);
                Assert.assertEquals((boolean)c.jmxStatistics().enabled(), (boolean)true);
            }
        });
    }

    public void testDefaultAndNamedCacheOverride() throws Exception {
        String cacheName = "ourCache";
        String xml1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.2 http://www.infinispan.org/schemas/infinispan-config-5.2.xsd\"\n      xmlns=\"urn:infinispan:config:5.2\">   <default>\n      <clustering mode=\"repl\">\n         <stateTransfer fetchInMemoryState=\"false\"/>\n         <async useReplQueue=\"false\" asyncMarshalling=\"false\"/>\n      </clustering>\n      <locking isolationLevel=\"REPEATABLE_READ\" concurrencyLevel=\"1000\" lockAcquisitionTimeout=\"20000\"/>\n      <storeAsBinary enabled=\"true\"/>\n      <expiration wakeUpInterval=\"23\" lifespan=\"50012\" maxIdle=\"1341\"/>\n      <deadlockDetection enabled=\"true\" spinDuration=\"1221\"/>\n   </default>\n   <namedCache name=\"ourCache\">\n      <clustering>\n         <async useReplQueue=\"true\" replQueueInterval=\"105\" replQueueMaxElements=\"341\"/>\n      </clustering>\n      <jmxStatistics enabled=\"true\"/>\n      <deadlockDetection enabled=\"true\" spinDuration=\"502\"/>\n      <deadlockDetection enabled=\"true\" spinDuration=\"1223\"/>\n   </namedCache></infinispan>";
        String xml2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.2 http://www.infinispan.org/schemas/infinispan-config-5.2.xsd\"\n      xmlns=\"urn:infinispan:config:5.2\">   <default>\n      <clustering mode=\"repl\">\n         <stateTransfer fetchInMemoryState=\"true\"/>\n         <sync replTimeout=\"30000\"/>\n      </clustering>\n      <locking isolationLevel=\"READ_COMMITTED\" concurrencyLevel=\"30\" lockAcquisitionTimeout=\"25000\"/>\n      <storeAsBinary enabled=\"false\"/>\n      <deadlockDetection enabled=\"true\" spinDuration=\"1222\"/>\n   </default>\n   <namedCache name=\"ourCache\">\n      <clustering mode=\"dist\">\n         <hash numOwners=\"3\" numSegments=\"51\"/>\n         <l1 enabled=\"true\" lifespan=\"12345\"/>\n         <async useReplQueue=\"false\"/>\n      </clustering>\n      <jmxStatistics enabled=\"true\"/>\n      <deadlockDetection enabled=\"true\" spinDuration=\"1224\"/>\n   </namedCache></infinispan>";
        ConfigurationBuilderHolder holder = TestCacheManagerFactory.buildAggregateHolder(xml1, xml2);
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createClusteredCacheManager(holder)){

            @Override
            public void call() {
                Configuration c = this.cm.getCacheConfiguration("ourCache");
                Assert.assertEquals((Object)c.clustering().cacheMode(), (Object)CacheMode.DIST_ASYNC);
                Assert.assertEquals((int)c.clustering().hash().numOwners(), (int)3);
                Assert.assertEquals((int)c.clustering().hash().numSegments(), (int)51);
                Assert.assertEquals((boolean)c.clustering().l1().enabled(), (boolean)true);
                Assert.assertEquals((long)c.clustering().l1().lifespan(), (long)12345L);
                Assert.assertEquals((boolean)c.clustering().stateTransfer().fetchInMemoryState(), (boolean)true);
                Assert.assertEquals((boolean)c.clustering().async().useReplQueue(), (boolean)false);
                Assert.assertEquals((long)c.clustering().async().replQueueInterval(), (long)105L);
                Assert.assertEquals((int)c.clustering().async().replQueueMaxElements(), (int)341);
                Assert.assertEquals((boolean)c.jmxStatistics().enabled(), (boolean)true);
                Assert.assertEquals((Object)c.locking().isolationLevel(), (Object)IsolationLevel.READ_COMMITTED);
                Assert.assertEquals((int)c.locking().concurrencyLevel(), (int)30);
                Assert.assertEquals((long)c.locking().lockAcquisitionTimeout(), (long)25000L);
                Assert.assertEquals((boolean)c.storeAsBinary().enabled(), (boolean)false);
                Assert.assertEquals((long)c.expiration().wakeUpInterval(), (long)23L);
                Assert.assertEquals((long)c.expiration().lifespan(), (long)50012L);
                Assert.assertEquals((long)c.expiration().maxIdle(), (long)1341L);
                Assert.assertEquals((boolean)c.deadlockDetection().enabled(), (boolean)true);
                Assert.assertEquals((long)c.deadlockDetection().spinDuration(), (long)1224L);
            }
        });
    }
}

