/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.module;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.infinispan.configuration.module.MyModuleConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="configuration.module.ExtendedParserTest")
public class ExtendedParserTest {
    public void testExtendedParser() throws IOException {
        String config = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.2 http://www.infinispan.org/schemas/infinispan-config-5.2.xsd\"\n      xmlns=\"urn:infinispan:config:5.2\">   <default>\n     <modules>\n       <sample-element xmlns=\"urn:infinispan:config:mymodule:5.2\" sample-attribute=\"test-value\" />\n     </modules>\n   </default>\n</infinispan>";
        this.assertCacheConfiguration(config);
    }

    private void assertCacheConfiguration(String config) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        ParserRegistry parserRegistry = new ParserRegistry(Thread.currentThread().getContextClassLoader());
        ConfigurationBuilderHolder holder = parserRegistry.parse((InputStream)is);
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createClusteredCacheManager(holder)){

            @Override
            public void call() {
                Assert.assertEquals((String)((MyModuleConfiguration)this.cm.getDefaultCacheConfiguration().module(MyModuleConfiguration.class)).attribute(), (String)"test-value");
            }
        });
    }
}

