/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.container.versioning.AbstractClusteredWriteSkewTest;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.distribution.MagicKey;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.annotations.Test;

@Test(testName="container.versioning.DistWriteSkewTest", groups={"functional"})
@CleanupAfterMethod
public class DistWriteSkewTest
extends AbstractClusteredWriteSkewTest {
    @Override
    protected CacheMode getCacheMode() {
        return CacheMode.DIST_SYNC;
    }

    @Override
    protected int clusterSize() {
        return 4;
    }

    public void testWriteSkew() throws Exception {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Cache cache2 = this.cache(2);
        Cache cache3 = this.cache(3);
        MagicKey hello = new MagicKey("hello", this.cache(2));
        cache1.put((Object)hello, (Object)"world 1");
        this.tm(1).begin();
        assert ("world 1".equals(cache1.get((Object)hello)));
        Transaction t = this.tm(1).suspend();
        cache3.put((Object)hello, (Object)"world 3");
        assert (cache0.get((Object)hello).equals("world 3"));
        assert (cache1.get((Object)hello).equals("world 3"));
        assert (cache2.get((Object)hello).equals("world 3"));
        assert (cache3.get((Object)hello).equals("world 3"));
        this.tm(1).resume(t);
        cache1.put((Object)hello, (Object)"world 2");
        try {
            this.tm(1).commit();
            assert (false) : "Transaction should roll back";
        }
        catch (RollbackException re) {
            // empty catch block
        }
        assert ("world 3".equals(cache0.get((Object)hello)));
        assert ("world 3".equals(cache1.get((Object)hello)));
        assert ("world 3".equals(cache2.get((Object)hello)));
        assert ("world 3".equals(cache3.get((Object)hello)));
    }

    public void testWriteSkewOnNonOwner() throws Exception {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Cache cache2 = this.cache(2);
        Cache cache3 = this.cache(3);
        MagicKey hello = new MagicKey("hello", this.cache(0));
        int[] owners = new int[]{0, 0};
        int[] nonOwners = new int[]{0, 0};
        int j = 0;
        int k = 0;
        for (int i = 0; i < 4; ++i) {
            if (DistributionTestHelper.isOwner(this.cache(i), hello)) {
                owners[j++] = i;
                continue;
            }
            nonOwners[k++] = i;
        }
        this.cache(owners[1]).put((Object)hello, (Object)"world 1");
        this.tm(nonOwners[0]).begin();
        assert ("world 1".equals(this.cache(nonOwners[0]).get((Object)hello)));
        Transaction t = this.tm(nonOwners[0]).suspend();
        this.cache(nonOwners[1]).put((Object)hello, (Object)"world 3");
        assert (cache0.get((Object)hello).equals("world 3"));
        assert (cache1.get((Object)hello).equals("world 3"));
        assert (cache2.get((Object)hello).equals("world 3"));
        assert (cache3.get((Object)hello).equals("world 3"));
        this.tm(nonOwners[0]).resume(t);
        this.cache(nonOwners[0]).put((Object)hello, (Object)"world 2");
        try {
            this.tm(nonOwners[0]).commit();
            assert (false) : "Transaction should roll back";
        }
        catch (RollbackException re) {
            // empty catch block
        }
        assert ("world 3".equals(cache0.get((Object)hello)));
        assert ("world 3".equals(cache1.get((Object)hello)));
        assert ("world 3".equals(cache2.get((Object)hello)));
        assert ("world 3".equals(cache3.get((Object)hello)));
    }

    public void testWriteSkewMultiEntries() throws Exception {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Cache cache2 = this.cache(2);
        Cache cache3 = this.cache(3);
        MagicKey hello = new MagicKey("hello", this.cache(2));
        MagicKey hello2 = new MagicKey("hello2", this.cache(3));
        MagicKey hello3 = new MagicKey("hello3", this.cache(0));
        this.tm(1).begin();
        cache1.put((Object)hello, (Object)"world 1");
        cache1.put((Object)hello2, (Object)"world 1");
        cache1.put((Object)hello3, (Object)"world 1");
        this.tm(1).commit();
        this.tm(1).begin();
        cache1.put((Object)hello2, (Object)"world 2");
        cache1.put((Object)hello3, (Object)"world 2");
        assert ("world 1".equals(cache1.get((Object)hello)));
        assert ("world 2".equals(cache1.get((Object)hello2)));
        assert ("world 2".equals(cache1.get((Object)hello3)));
        Transaction t = this.tm(1).suspend();
        cache3.put((Object)hello, (Object)"world 3");
        for (Cache c : this.caches()) {
            assert ("world 3".equals(c.get((Object)hello)));
            assert ("world 1".equals(c.get((Object)hello2)));
            assert ("world 1".equals(c.get((Object)hello3)));
        }
        this.tm(1).resume(t);
        cache1.put((Object)hello, (Object)"world 2");
        try {
            this.tm(1).commit();
            assert (false) : "Transaction should roll back";
        }
        catch (RollbackException re) {
            // empty catch block
        }
        for (Cache c : this.caches()) {
            assert ("world 3".equals(c.get((Object)hello)));
            assert ("world 1".equals(c.get((Object)hello2)));
            assert ("world 1".equals(c.get((Object)hello3)));
        }
    }

    public void testNullEntries() throws Exception {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Cache cache2 = this.cache(2);
        Cache cache3 = this.cache(3);
        MagicKey hello = new MagicKey("hello", this.cache(2));
        cache0.put((Object)hello, (Object)"world");
        this.tm(0).begin();
        assert ("world".equals(cache0.get((Object)hello)));
        Transaction t = this.tm(0).suspend();
        cache1.remove((Object)hello);
        assert (null == cache0.get((Object)hello));
        assert (null == cache1.get((Object)hello));
        assert (null == cache2.get((Object)hello));
        assert (null == cache3.get((Object)hello));
        this.tm(0).resume(t);
        cache0.put((Object)hello, (Object)"world2");
        try {
            this.tm(0).commit();
            assert (false) : "This transaction should roll back";
        }
        catch (RollbackException expected) {
            // empty catch block
        }
        assert (null == cache0.get((Object)hello));
        assert (null == cache1.get((Object)hello));
        assert (null == cache2.get((Object)hello));
        assert (null == cache3.get((Object)hello));
    }

    public void testResendPrepare() throws Exception {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Cache cache2 = this.cache(2);
        Cache cache3 = this.cache(3);
        MagicKey hello = new MagicKey("hello", this.cache(2));
        cache0.put((Object)hello, (Object)"world");
        this.tm(2).begin();
        assert ("world".equals(cache2.get((Object)hello)));
        Transaction t = this.tm(2).suspend();
        this.cache(0).put((Object)hello, (Object)"world 2");
        assert (cache0.get((Object)hello).equals("world 2"));
        assert (cache1.get((Object)hello).equals("world 2"));
        assert (cache2.get((Object)hello).equals("world 2"));
        assert (cache3.get((Object)hello).equals("world 2"));
        this.tm(2).resume(t);
        cache2.put((Object)hello, (Object)"world 3");
        try {
            this.tm(2).commit();
            assert (false) : "This transaction should roll back";
        }
        catch (RollbackException expected) {
            // empty catch block
        }
        assert (cache0.get((Object)hello).equals("world 2"));
        assert (cache1.get((Object)hello).equals("world 2"));
        assert (cache2.get((Object)hello).equals("world 2"));
        assert (cache3.get((Object)hello).equals("world 2"));
    }

    public void testLocalOnlyPut() {
        this.localOnlyPut(this.cache(0), 1, "v1");
        this.localOnlyPut(this.cache(1), 2, "v2");
        this.localOnlyPut(this.cache(2), 3, "v3");
        this.localOnlyPut(this.cache(3), 4, "v4");
    }

    private void localOnlyPut(Cache<Integer, String> cache, Integer k, String v) {
        cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)k, (Object)v);
    }
}

