/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedTask;
import org.infinispan.distexec.DistributedTaskBuilder;
import org.infinispan.distexec.DistributedTaskExecutionPolicy;
import org.infinispan.distexec.LocalDistributedExecutorTest;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.TopologyAwareAddress;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distexec.DistributedExecutorExecutionPolicyTest")
public class DistributedExecutorExecutionPolicyTest
extends MultipleCacheManagersTest {
    public static final String CACHE_NAME = "TestCache";

    public DistributedExecutorExecutionPolicyTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
    }

    public EmbeddedCacheManager createCacheManager(int counter, int siteId, int machineId, int rackId) {
        ConfigurationBuilder builder = DistributedExecutorExecutionPolicyTest.getDefaultClusteredCacheConfig(this.getCacheMode(), false);
        GlobalConfigurationBuilder globalConfigurationBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        globalConfigurationBuilder.transport().machineId("m" + (machineId > 0 ? machineId : counter)).rackId("r" + (rackId > 0 ? rackId : counter)).siteId("s" + (siteId > 0 ? siteId : counter));
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager(globalConfigurationBuilder, builder);
        cm1.defineConfiguration(CACHE_NAME, builder.build());
        return cm1;
    }

    public CacheMode getCacheMode() {
        return CacheMode.DIST_SYNC;
    }

    public void testExecutionPolicyNotSameMachine() throws ExecutionException, InterruptedException {
        for (int i = 1; i <= 2; ++i) {
            this.cacheManagers.add(this.createCacheManager(i, 0, 0, 0));
        }
        this.waitForClusterToForm();
        this.executeDifferentExecutionPolicies(DistributedTaskExecutionPolicy.SAME_MACHINE);
    }

    public void testExecutionPolicySameMachine() throws ExecutionException, InterruptedException {
        this.cacheManagers.add(this.createCacheManager(1, 0, 0, 0));
        this.cacheManagers.add(this.createCacheManager(2, 1, 1, 1));
        this.waitForClusterToForm();
        this.executeDifferentExecutionPolicies(DistributedTaskExecutionPolicy.SAME_MACHINE);
    }

    public void testExecutionPolicyNotSameSiteFilter() throws ExecutionException, InterruptedException {
        for (int i = 1; i <= 2; ++i) {
            this.cacheManagers.add(this.createCacheManager(i, 0, 0, 0));
        }
        this.waitForClusterToForm();
        this.executeDifferentExecutionPolicies(DistributedTaskExecutionPolicy.SAME_SITE);
    }

    public void testExecutionPolicySameSiteFilter() throws ExecutionException, InterruptedException {
        this.cacheManagers.add(this.createCacheManager(1, 0, 0, 0));
        this.cacheManagers.add(this.createCacheManager(2, 1, 0, 0));
        this.waitForClusterToForm();
        this.executeDifferentExecutionPolicies(DistributedTaskExecutionPolicy.SAME_SITE);
    }

    public void testExecutionPolicyNotSameRackFilter() throws ExecutionException, InterruptedException {
        for (int i = 1; i <= 2; ++i) {
            this.cacheManagers.add(this.createCacheManager(i, 0, 0, 0));
        }
        this.waitForClusterToForm();
        this.executeDifferentExecutionPolicies(DistributedTaskExecutionPolicy.SAME_RACK);
    }

    public void testExecutionPolicySameRackFilter() throws ExecutionException, InterruptedException {
        this.cacheManagers.add(this.createCacheManager(1, 0, 0, 0));
        this.cacheManagers.add(this.createCacheManager(2, 1, 0, 1));
        this.waitForClusterToForm();
        this.executeDifferentExecutionPolicies(DistributedTaskExecutionPolicy.SAME_RACK);
    }

    private void executeDifferentExecutionPolicies(DistributedTaskExecutionPolicy policy) throws ExecutionException, InterruptedException {
        assert (this.address(0) instanceof TopologyAwareAddress);
        assert (this.address(1) instanceof TopologyAwareAddress);
        Cache cache1 = this.cache(0, CACHE_NAME);
        Cache cache2 = this.cache(1, CACHE_NAME);
        cache1.put((Object)"key1", (Object)"value1");
        cache1.put((Object)"key2", (Object)"value2");
        cache1.put((Object)"key3", (Object)"value3");
        cache1.put((Object)"key4", (Object)"value4");
        cache2.put((Object)"key5", (Object)"value5");
        cache2.put((Object)"key6", (Object)"value6");
        DefaultExecutorService des = new DefaultExecutorService(cache1);
        DistributedTaskBuilder taskBuilder = des.createDistributedTaskBuilder((Callable)((Object)new LocalDistributedExecutorTest.SimpleDistributedCallable(true)));
        taskBuilder.executionPolicy(policy);
        DistributedTask distributedTask = taskBuilder.build();
        Future future = des.submit(distributedTask, (Object[])new String[]{"key1", "key6"});
        assert (((Boolean)future.get()).booleanValue());
    }
}

