/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.AbstractInProcessFuture;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(testName="distribution.ConcurrentStartWithReplTest", groups={"functional"})
public class ConcurrentStartWithReplTest
extends AbstractInfinispanTest {
    Configuration replCfg;
    Configuration distCfg;

    @BeforeTest
    public void setUp() {
        this.replCfg = MultipleCacheManagersTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC);
        this.replCfg.setFetchInMemoryState(true);
        this.distCfg = MultipleCacheManagersTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC);
        this.distCfg.setRehashEnabled(true);
    }

    @Test(timeOut=60000L)
    public void testSequence1() throws ExecutionException, InterruptedException {
        TestCacheManagerFactory.backgroundTestStarted(this);
        this.doTest(true, false);
    }

    @Test(timeOut=60000L)
    public void testSequence2() throws ExecutionException, InterruptedException {
        TestCacheManagerFactory.backgroundTestStarted(this);
        this.doTest(false, false);
    }

    @Test(timeOut=60000L)
    public void testSequence3() throws ExecutionException, InterruptedException {
        TestCacheManagerFactory.backgroundTestStarted(this);
        this.doTest(true, true);
    }

    @Test(timeOut=60000L)
    public void testSequence4() throws ExecutionException, InterruptedException {
        TestCacheManagerFactory.backgroundTestStarted(this);
        this.doTest(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(boolean inOrder, boolean nonBlockingStartupForDist) throws ExecutionException, InterruptedException {
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createCacheManager(GlobalConfiguration.getClusteredDefault());
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createCacheManager(GlobalConfiguration.getClusteredDefault());
        try {
            cm1.defineConfiguration("r", this.replCfg);
            cm1.defineConfiguration("d", this.distCfg);
            cm2.defineConfiguration("r", this.replCfg);
            cm2.defineConfiguration("d", this.distCfg);
            Cache<String, String> c1r = this.startCache((CacheContainer)cm1, "r", false).get();
            c1r.put((Object)"key", (Object)"value");
            Cache<String, String> c2r = this.startCache((CacheContainer)cm2, "r", false).get();
            TestingUtil.blockUntilViewsReceived(10000L, c1r, c2r);
            TestingUtil.waitForRehashToComplete(c1r, c2r);
            assert ("value".equals(c2r.get((Object)"key")));
            Future<Cache<String, String>> c1df = this.startCache((CacheContainer)(inOrder ? cm1 : cm2), "d", nonBlockingStartupForDist);
            Future<Cache<String, String>> c2df = this.startCache((CacheContainer)(inOrder ? cm2 : cm1), "d", nonBlockingStartupForDist);
            Cache<String, String> c1d = c1df.get();
            Cache<String, String> c2d = c2df.get();
            c1d.put((Object)"key", (Object)"value");
            assert ("value".equals(c2d.get((Object)"key")));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm1, cm2);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm1, cm2);
    }

    private Future<Cache<String, String>> startCache(final CacheContainer cm, final String cacheName, boolean nonBlockingStartup) {
        final Callable<Cache<String, String>> cacheCreator = new Callable<Cache<String, String>>(){

            @Override
            public Cache<String, String> call() throws Exception {
                Cache c = cm.getCache(cacheName);
                return c;
            }
        };
        if (nonBlockingStartup) {
            return this.fork(cacheCreator);
        }
        return new AbstractInProcessFuture<Cache<String, String>>(){

            public Cache<String, String> get() throws InterruptedException, ExecutionException {
                try {
                    return (Cache)cacheCreator.call();
                }
                catch (Exception e) {
                    throw new ExecutionException(e);
                }
            }
        };
    }
}

