/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.distribution.BaseDistCacheStoreTest;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.util.concurrent.NotifyingFuture;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.DistSyncCacheStoreNotSharedTest")
@CleanupAfterMethod
public class DistSyncCacheStoreNotSharedTest
extends BaseDistCacheStoreTest {
    private static final String k1 = "1";
    private static final String v1 = "one";
    private static final String k2 = "2";
    private static final String v2 = "two";
    private static final String k3 = "3";
    private static final String v3 = "three";
    private static final String k4 = "4";
    private static final String v4 = "four";
    private static final String[] keys = new String[]{"1", "2", "3", "4"};

    public DistSyncCacheStoreNotSharedTest() {
        this.sync = true;
        this.tx = false;
        this.testRetVals = true;
        this.shared = false;
    }

    public void testPutFromNonOwner() throws Exception {
        String key = "k2";
        String value = "value2";
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
        Cache<Object, String> nonOwner = this.getFirstNonOwner(key);
        Cache<Object, String> owner = this.getFirstOwner(key);
        CacheStore nonOwnerStore = TestingUtil.extractComponent(nonOwner, CacheLoaderManager.class).getCacheStore();
        CacheStore ownerStore = TestingUtil.extractComponent(owner, CacheLoaderManager.class).getCacheStore();
        assert (!nonOwnerStore.containsKey((Object)key));
        assert (!ownerStore.containsKey((Object)key));
        Object retval = nonOwner.put((Object)key, (Object)value);
        assert (!nonOwnerStore.containsKey((Object)key));
        assert (ownerStore.containsKey((Object)key));
        if (this.testRetVals) assert (retval == null);
        this.assertOnAllCachesAndOwnership(key, value);
    }

    public void testGetFromNonOwnerWithFlags() throws Exception {
        String key = "k2";
        String value = "value2";
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
        Cache<Object, String> nonOwner = this.getFirstNonOwner(key);
        Cache<Object, String> owner = this.getFirstOwner(key);
        CacheStore ownerStore = TestingUtil.extractComponent(owner, CacheLoaderManager.class).getCacheStore();
        owner.put((Object)key, (Object)value);
        assert (value.equals(ownerStore.load((Object)key).getValue()));
        owner.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).clear();
        assert (value.equals(ownerStore.load((Object)key).getValue()));
        assert (owner.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).get((Object)key) == null);
        assert (nonOwner.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).get((Object)key) == null);
        assert (value.equals(nonOwner.get((Object)key)));
        this.assertOnAllCaches(key, value);
        this.assertOwnershipAndNonOwnership(key, true);
    }

    public void testAsyncGetCleansContextFlags() throws Exception {
        String key = "k2";
        String value = "value2";
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
        Cache<Object, String> nonOwner = this.getFirstNonOwner(key);
        Cache<Object, String> owner = this.getFirstOwner(key);
        owner.put((Object)key, (Object)value);
        owner.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).clear();
        NotifyingFuture async = nonOwner.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).getAsync((Object)key);
        assert (async != null);
        assert (async.get() == null);
        async = nonOwner.getAdvancedCache().getAsync((Object)key);
        assert (async != null);
        String returnedValue = (String)async.get();
        assert (value.equals(returnedValue));
    }

    public void testPutFromNonOwnerWithFlags() throws Exception {
        String key = "k2";
        String value = "value2";
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
        Cache<Object, String> nonOwner = this.getFirstNonOwner(key);
        Cache<Object, String> owner = this.getFirstOwner(key);
        CacheStore nonOwnerStore = TestingUtil.extractComponent(nonOwner, CacheLoaderManager.class).getCacheStore();
        CacheStore ownerStore = TestingUtil.extractComponent(owner, CacheLoaderManager.class).getCacheStore();
        assert (!nonOwnerStore.containsKey((Object)key));
        assert (!ownerStore.containsKey((Object)key));
        Object retval = nonOwner.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).put((Object)key, (Object)value);
        assert (!nonOwnerStore.containsKey((Object)key));
        assert (!ownerStore.containsKey((Object)key));
        if (this.testRetVals) assert (retval == null);
        this.assertOnAllCachesAndOwnership(key, value);
    }

    public void testPutFromOwner() throws Exception {
        String key = "k3";
        String value = "value3";
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
        this.getOwners(key)[0].put((Object)key, (Object)value);
        for (Cache c : this.caches) {
            CacheStore store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            if (this.isOwner(c, key)) {
                this.assertIsInContainerImmortal(c, key);
                assert (store.containsKey((Object)key));
                continue;
            }
            this.assertIsNotInL1(c, key);
            assert (!store.containsKey((Object)key));
        }
    }

    public void testPutAll() throws Exception {
        this.c1.putAll(this.makePutAllTestData());
        for (Cache c : this.caches) {
            CacheStore store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            for (String key : keys) {
                if (this.isOwner(c, key)) {
                    this.assertIsInContainerImmortal(c, key);
                    assert (store.containsKey((Object)key));
                    continue;
                }
                assert (!store.containsKey((Object)key));
            }
        }
    }

    public void testExpectedConfig() {
        assert (this.c1.getCacheConfiguration().locking().supportsConcurrentUpdates());
    }

    public void testPutAllWithFlags() throws Exception {
        Map<String, String> data = this.makePutAllTestData();
        this.c1.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).putAll(data);
        for (Cache c : this.caches) {
            CacheStore store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            for (String key : keys) {
                assert (!store.containsKey((Object)key));
                if (!this.isOwner(c, key)) continue;
                this.assertIsInContainerImmortal(c, key);
            }
        }
    }

    public void testRemoveFromNonOwner() throws Exception {
        String key = "k1";
        String value = "value";
        this.initAndTest();
        for (Cache c : this.caches) {
            CacheStore store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            if (this.isOwner(c, key)) {
                this.assertIsInContainerImmortal(c, key);
                assert (store.load((Object)key).getValue().equals(value));
                continue;
            }
            assert (!store.containsKey((Object)key));
        }
        Object retval = this.getFirstNonOwner(key).remove((Object)key);
        if (this.testRetVals) assert ("value".equals(retval));
        for (Cache c : this.caches) {
            CacheStore store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            assert (!store.containsKey((Object)key));
        }
    }

    public void testRemoveFromNonOwnerWithFlags() throws Exception {
        String key = "k1";
        String value = "value";
        this.initAndTest();
        Object retval = this.getFirstNonOwner(key).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).remove((Object)key);
        if (this.testRetVals) assert (value.equals(retval));
        for (Cache c : this.caches) {
            if (!this.isOwner(c, key)) continue;
            CacheStore store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            assert (store.containsKey((Object)key));
        }
    }

    public void testReplaceFromNonOwner() throws Exception {
        String key = "k1";
        String value = "value";
        String value2 = "v2";
        this.initAndTest();
        for (Cache c : this.caches) {
            CacheStore store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            if (this.isOwner(c, key)) {
                this.assertIsInContainerImmortal(c, key);
                assert (store.load((Object)key).getValue().equals(value));
                continue;
            }
            assert (!store.containsKey((Object)key));
        }
        Object retval = this.getFirstNonOwner(key).replace((Object)key, (Object)value2);
        if (this.testRetVals) assert (value.equals(retval));
        for (Cache c : this.caches) {
            CacheStore store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            if (this.isOwner(c, key)) {
                this.assertIsInContainerImmortal(c, key);
                assert (((String)c.get((Object)key)).equals(value2));
                assert (store.load((Object)key).getValue().equals(value2));
                continue;
            }
            assert (!store.containsKey((Object)key));
        }
    }

    public void testReplaceFromNonOwnerWithFlag() throws Exception {
        String key = "k1";
        String value = "value";
        String value2 = "v2";
        this.initAndTest();
        Object retval = this.getFirstNonOwner(key).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).replace((Object)key, (Object)value2);
        if (this.testRetVals) assert (value.equals(retval));
        for (Cache c : this.caches) {
            CacheStore store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            if (this.isOwner(c, key)) {
                this.assertIsInContainerImmortal(c, key);
                assert (((String)c.get((Object)key)).equals(value2));
                assert (store.load((Object)key).getValue().equals(value));
                continue;
            }
            assert (!store.containsKey((Object)key));
        }
    }

    public void testAtomicReplaceFromNonOwner() throws Exception {
        String key = "k1";
        String value = "value";
        String value2 = "v2";
        this.initAndTest();
        boolean replaced = this.getFirstNonOwner(key).replace((Object)key, (Object)value2, (Object)value);
        Assert.assertFalse((boolean)replaced);
        replaced = this.getFirstNonOwner(key).replace((Object)key, (Object)value, (Object)value2);
        Assert.assertTrue((boolean)replaced);
        for (Cache c : this.caches) {
            Assert.assertEquals((Object)value2, (Object)c.get((Object)key));
            if (!this.isOwner(c, key)) continue;
            CacheStore store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            Assert.assertTrue((boolean)store.containsKey((Object)key));
            Assert.assertEquals((Object)value2, (Object)store.load((Object)key).getValue());
        }
    }

    public void testAtomicReplaceFromNonOwnerWithFlag() throws Exception {
        String key = "k1";
        String value = "value";
        String value2 = "v2";
        this.initAndTest();
        boolean replaced = this.getFirstNonOwner(key).replace((Object)key, (Object)value2, (Object)value);
        Assert.assertFalse((boolean)replaced);
        replaced = this.getFirstNonOwner(key).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).replace((Object)key, (Object)value, (Object)value2);
        Assert.assertTrue((boolean)replaced);
        for (Cache c : this.caches) {
            Assert.assertEquals((Object)value2, (Object)c.get((Object)key));
            if (!this.isOwner(c, key)) continue;
            CacheStore store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            Assert.assertTrue((boolean)store.containsKey((Object)key));
            Assert.assertEquals((Object)value, (Object)store.load((Object)key).getValue());
        }
    }

    public void testAtomicPutIfAbsentFromNonOwner() throws Exception {
        String key = "k1";
        String value = "value";
        String value2 = "v2";
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
        String replaced = (String)this.getFirstNonOwner(key).putIfAbsent((Object)"k1", (Object)value);
        Assert.assertNull((Object)replaced);
        replaced = (String)this.getFirstNonOwner(key).putIfAbsent((Object)"k1", (Object)value2);
        Assert.assertEquals((Object)replaced, (Object)value);
        for (Cache c : this.caches) {
            Assert.assertEquals((Object)replaced, (Object)c.get((Object)key));
            if (!this.isOwner(c, key)) continue;
            CacheStore store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            Assert.assertTrue((boolean)store.containsKey((Object)key));
            Assert.assertEquals((Object)value, (Object)store.load((Object)key).getValue());
        }
    }

    public void testAtomicPutIfAbsentFromNonOwnerWithFlag() throws Exception {
        String key = "k1";
        String value = "value";
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
        String replaced = (String)this.getFirstNonOwner(key).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).putIfAbsent((Object)"k1", (Object)value);
        Assert.assertNull((Object)replaced);
        replaced = (String)this.getFirstNonOwner(key).putIfAbsent((Object)"k1", (Object)value);
        Assert.assertEquals((Object)replaced, (Object)value);
        for (Cache c : this.caches) {
            Assert.assertEquals((Object)replaced, (Object)c.get((Object)key));
            CacheStore store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            Assert.assertFalse((boolean)store.containsKey((Object)key));
        }
    }

    public void testClear() throws Exception {
        this.prepareClearTest();
        this.c1.clear();
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
        for (int i = 0; i < 5; ++i) {
            String key = "k" + i;
            for (Cache c : this.caches) {
                CacheStore store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
                assert (!store.containsKey((Object)key));
            }
        }
    }

    public void testClearWithFlag() throws Exception {
        this.prepareClearTest();
        this.c1.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).clear();
        for (Cache c : this.caches) {
            assert (c.isEmpty()) : "Data container " + c + " should be empty, instead it contains keys " + c.keySet();
            CacheStore store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            for (int i = 0; i < 5; ++i) {
                String key = "k" + i;
                if (this.isOwner(c, key)) assert (store.containsKey((Object)key));
            }
        }
    }

    private Map<String, String> makePutAllTestData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(k1, v1);
        data.put(k2, v2);
        data.put(k3, v3);
        data.put(k4, v4);
        return data;
    }

    private void prepareClearTest() throws CacheLoaderException {
        int i;
        for (Cache c : this.caches) {
            assert (c.isEmpty()) : "Data container " + c + " should be empty, instead it contains keys " + c.keySet();
        }
        for (i = 0; i < 5; ++i) {
            this.getOwners("k" + i)[0].put((Object)("k" + i), (Object)("value" + i));
        }
        for (i = 0; i < 5; ++i) {
            this.assertOnAllCachesAndOwnership("k" + i, "value" + i);
        }
        for (Cache c : this.caches) {
            assert (!c.isEmpty());
            CacheStore store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            for (int i2 = 0; i2 < 5; ++i2) {
                String key = "k" + i2;
                if (this.isOwner(c, key)) assert (store.containsKey((Object)key)) : "Cache store " + c + " does not contain key " + key;
            }
        }
    }
}

