/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.rehash.RehashLeaveTestBase;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.ConcurrentNonOverlappingLeaveTest")
public class ConcurrentNonOverlappingLeaveTest
extends RehashLeaveTestBase {
    Address l1;
    Address l2;
    private Set<Integer> lostSegments = new HashSet<Integer>();

    @Override
    protected void assertOwnershipAndNonOwnership(Object key, boolean allowL1) {
        if (this.lostSegments.contains(this.getConsistentHash(this.c1).getSegment(key))) {
            return;
        }
        super.assertOwnershipAndNonOwnership(key, allowL1);
    }

    @Override
    protected void assertOnAllCaches(Object key, String value) {
        if (this.lostSegments.contains(this.getConsistentHash(this.c1).getSegment(key))) {
            return;
        }
        super.assertOnAllCaches(key, value);
    }

    @Override
    void performRehashEvent(boolean offline) {
        this.l1 = this.addressOf(this.c2);
        this.l2 = this.addressOf(this.c4);
        List<Address> killedNodes = Arrays.asList(this.l1, this.l2);
        EmbeddedCacheManager cm2 = this.c2.getCacheManager();
        EmbeddedCacheManager cm4 = this.c4.getCacheManager();
        HashSet<Integer> overlappingSegments = new HashSet<Integer>();
        ConsistentHash ch = this.getConsistentHash(this.c1);
        for (int segment = 0; segment < ch.getNumSegments(); ++segment) {
            List owners = ch.locateOwnersForSegment(segment);
            if (!owners.containsAll(killedNodes)) continue;
            overlappingSegments.add(segment);
        }
        this.lostSegments = overlappingSegments;
        this.log.tracef("These segments will be lost after killing nodes %s: %s", killedNodes, this.lostSegments);
        this.cacheManagers.removeAll(Arrays.asList(cm2, cm4));
        this.caches.removeAll(Arrays.asList(this.c2, this.c4));
        TestingUtil.killCacheManagers(new CacheContainer[]{cm2, cm4});
    }
}

