/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.distribution.MagicKey;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.L1OnRehashTest")
public class L1OnRehashTest
extends BaseDistFunctionalTest {
    EmbeddedCacheManager joinerManager1;
    EmbeddedCacheManager joinerManager2;
    Cache<Object, String> joiner1;
    Cache<Object, String> joiner2;

    public L1OnRehashTest() {
        this.tx = false;
        this.sync = true;
        this.l1CacheEnabled = true;
        this.performRehashing = true;
        this.l1OnRehash = true;
        this.INIT_CLUSTER_SIZE = 3;
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    void performRehashEvent() {
        this.joinerManager1 = this.addClusterEnabledCacheManager();
        this.joinerManager1.defineConfiguration(this.cacheName, this.configuration.build());
        this.joiner1 = this.joinerManager1.getCache(this.cacheName);
        this.joinerManager2 = this.addClusterEnabledCacheManager();
        this.joinerManager2.defineConfiguration(this.cacheName, this.configuration.build());
        this.joiner2 = this.joinerManager2.getCache(this.cacheName);
        TestingUtil.blockUntilViewsReceived(TimeUnit.SECONDS.toMillis(10L), this.c1, this.c2, this.c3, this.joiner1, this.joiner2);
        TestingUtil.waitForRehashToComplete(this.c1, this.c2, this.c3, this.joiner1, this.joiner2);
        this.caches.add(this.joiner1);
        this.caches.add(this.joiner2);
    }

    private List<MagicKey> init() {
        int i;
        ArrayList<MagicKey> keys = new ArrayList<MagicKey>(Arrays.asList(new MagicKey("k1", this.c1), new MagicKey("k2", this.c3), new MagicKey("k3", this.c2)));
        for (i = 0; i < keys.size(); ++i) {
            Cache c = this.cache(i, this.cacheName);
            c.put(keys.get(i), (Object)("v" + (i + 1)));
        }
        for (i = 0; i < keys.size(); ++i) {
            Object key = keys.get(i);
            this.assertOwnershipAndNonOwnership(key, this.l1CacheEnabled);
            this.assertOnAllCaches(key, "v" + (i + 1));
        }
        this.log.infof("Initialized with keys %s", keys);
        return keys;
    }

    public void testInvalidationBehaviorOnRehash() {
        int i;
        MagicKey key2;
        List<MagicKey> keys = this.init();
        this.performRehashEvent();
        for (MagicKey key2 : keys) {
            this.assertOwnershipAndNonOwnership(key2, true);
        }
        for (i = 0; i < keys.size(); ++i) {
            key2 = keys.get(i);
            Cache owner = this.getLockOwner(key2, this.cacheName);
            owner.put((Object)keys.get(i), (Object)("nv" + (i + 1)));
        }
        for (i = 0; i < keys.size(); ++i) {
            key2 = keys.get(i);
            this.assertOwnershipAndNonOwnership(key2, this.l1OnRehash);
            if (this.l1OnRehash) continue;
            this.assertOnAllCaches(key2, "nv" + (i + 1));
        }
    }
}

