/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.Arrays;
import org.infinispan.Cache;
import org.infinispan.distribution.BaseDistCacheStoreTest;
import org.infinispan.distribution.MagicKey;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(testName="distribution.rehash.RehashWithSharedCacheStore", groups={"functional"})
public class RehashWithSharedCacheStore
extends BaseDistCacheStoreTest {
    private static final Log log = LogFactory.getLog(RehashWithSharedCacheStore.class);

    public RehashWithSharedCacheStore() {
        this.INIT_CLUSTER_SIZE = 3;
        this.sync = true;
        this.tx = false;
        this.testRetVals = true;
        this.shared = true;
        this.performRehashing = true;
    }

    private CacheStore getCacheStore(Cache<?, ?> cache) {
        CacheLoaderManager clm = (CacheLoaderManager)cache.getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class);
        return clm.getCacheStore();
    }

    private int getCacheStoreStats(Cache<?, ?> cache, String cacheStoreMethod) {
        DummyInMemoryCacheStore cs = (DummyInMemoryCacheStore)this.getCacheStore(cache);
        return cs.stats().get(cacheStoreMethod);
    }

    public void testRehashes() throws CacheLoaderException {
        int numWrites;
        MagicKey k = new MagicKey("k", this.c1);
        this.c1.put((Object)k, (Object)"v");
        Cache<Object, String>[] owners = this.getOwners(k);
        log.infof("Initial owners list for key %s: %s", (Object)k, Arrays.asList(owners));
        for (Cache c : Arrays.asList(this.c1, this.c2, this.c3)) {
            assert (this.getCacheStore(c).containsKey((Object)k)) : String.format("CacheStore on %s should contain key %s", c, k);
        }
        Cache<Object, String> primaryOwner = owners[0];
        if (this.getCacheStoreStats(primaryOwner, "store") == 0) {
            primaryOwner = owners[1];
        }
        for (Cache<Object, String> c : owners) {
            numWrites = this.getCacheStoreStats(c, "store");
            assert (numWrites == 1) : "store() should have been invoked on the cache store once.  Was " + numWrites;
        }
        log.infof("Stopping node %s", primaryOwner);
        this.caches.remove(primaryOwner);
        primaryOwner.stop();
        primaryOwner.getCacheManager().stop();
        TestingUtil.blockUntilViewsReceived(60000, false, this.caches);
        TestingUtil.waitForRehashToComplete(this.caches);
        owners = this.getOwners(k);
        log.infof("After shutting one node down, owners list for key %s: %s", (Object)k, Arrays.asList(owners));
        assert (owners.length == 2);
        for (Cache<Object, String> o : owners) {
            numWrites = this.getCacheStoreStats(o, "store");
            assert (numWrites == 1) : "store() should have been invoked on the cache store once.  Was " + numWrites;
            assert ("v".equals(o.get((Object)k))) : "Should be able to see key on new owner";
        }
    }
}

