/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.distribution.MagicKey;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.InboundInvocationHandler;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.CommandAwareRpcDispatcher;
import org.infinispan.statetransfer.StateChunk;
import org.infinispan.statetransfer.StateRequestCommand;
import org.infinispan.statetransfer.StateResponseCommand;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.tx.dld.ControlledRpcManager;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.testng.Assert;
import org.testng.annotations.Test;

@CleanupAfterMethod
@Test(groups={"functional"}, testName="distribution.rehash.StateResponseOrderingTest")
public class StateResponseOrderingTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        builder.clustering().cacheMode(CacheMode.DIST_SYNC).hash().numOwners(3);
        this.createCluster(builder, 4);
        this.waitForClusterToForm();
    }

    public void testOldStateResponse() throws Throwable {
        MagicKey k1 = new MagicKey("k1", this.cache(1));
        MagicKey k2 = new MagicKey("k2", this.cache(2));
        MagicKey k3 = new MagicKey("k3", this.cache(3));
        this.cache(1).put((Object)k1, (Object)"v1");
        this.cache(2).put((Object)k2, (Object)"v2");
        this.cache(3).put((Object)k3, (Object)"v3");
        final StateTransferManager stm = this.cache(0).getAdvancedCache().getComponentRegistry().getStateTransferManager();
        int initialTopologyId = stm.getCacheTopology().getTopologyId();
        RpcManager rm = TestingUtil.extractComponent(this.cache(0), RpcManager.class);
        ControlledRpcManager crm = new ControlledRpcManager(rm);
        crm.blockBefore(StateRequestCommand.class);
        TestingUtil.replaceComponent(this.cache(0), RpcManager.class, crm, true);
        this.cache(3).stop();
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return stm.getCacheTopology().getPendingCH() != null;
            }
        });
        InboundInvocationHandler iih = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(0), InboundInvocationHandler.class);
        StateChunk stateChunk = new StateChunk(0, Collections.emptyList(), true);
        StateResponseCommand stateResponseCommand = new StateResponseCommand("___defaultcache", this.address(3), initialTopologyId, Arrays.asList(stateChunk));
        iih.handle((CacheRpcCommand)stateResponseCommand, this.address(3));
        crm.stopBlocking();
        TestingUtil.waitForRehashToComplete(this.cache(0), this.cache(1), this.cache(2));
        DataContainer dataContainer = TestingUtil.extractComponent(this.cache(0), DataContainer.class);
        Assert.assertTrue((boolean)dataContainer.containsKey((Object)k1));
        Assert.assertTrue((boolean)dataContainer.containsKey((Object)k2));
        Assert.assertTrue((boolean)dataContainer.containsKey((Object)k3));
    }

    public void testStateResponseWhileRestartingBrokenTransfers() throws Throwable {
        MagicKey k1 = new MagicKey("k1", this.cache(1), this.cache(2), this.cache(3));
        this.cache(0).put((Object)k1, (Object)"v1");
        final StateTransferManager stm = this.cache(0).getAdvancedCache().getComponentRegistry().getStateTransferManager();
        final int initialTopologyId = stm.getCacheTopology().getTopologyId();
        CheckPoint checkPoint = new CheckPoint();
        this.replaceInvocationHandler(checkPoint, this.manager(0), StateResponseCommand.class);
        this.replaceInvocationHandler(checkPoint, this.manager(1), StateRequestCommand.class);
        this.replaceInvocationHandler(checkPoint, this.manager(2), StateRequestCommand.class);
        this.log.debugf("Killing node %s", (Object)this.address(3));
        this.cache(3).stop();
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return stm.getCacheTopology().getTopologyId() == initialTopologyId + 2;
            }
        });
        checkPoint.trigger("OUT_GET_TRANSACTIONS_" + this.address(1));
        checkPoint.trigger("OUT_GET_TRANSACTIONS_" + this.address(2));
        checkPoint.awaitStrict("IN_GET_TRANSACTIONS_" + this.address(1), 10L, TimeUnit.SECONDS);
        checkPoint.awaitStrict("IN_GET_TRANSACTIONS_" + this.address(2), 10L, TimeUnit.SECONDS);
        String event = checkPoint.peek(5L, TimeUnit.SECONDS, "IN_START_STATE_TRANSFER_" + this.address(1), "IN_START_STATE_TRANSFER_" + this.address(2));
        int liveNode = event.endsWith(this.address(1).toString()) ? 1 : 2;
        int nodeToKill = liveNode == 1 ? 2 : 1;
        List keyOwners = this.cache(0).getAdvancedCache().getDistributionManager().locate((Object)k1);
        this.log.debugf("Killing node %s. Key %s is located on %s", (Object)this.address(nodeToKill), (Object)k1, (Object)keyOwners);
        this.log.debugf("Data on node %s: %s", (Object)this.address(1), (Object)this.cache(1).keySet());
        this.log.debugf("Data on node %s: %s", (Object)this.address(2), (Object)this.cache(2).keySet());
        checkPoint.await("IN_START_STATE_TRANSFER_" + this.address(liveNode), 1L, TimeUnit.SECONDS);
        checkPoint.trigger("OUT_START_STATE_TRANSFER_" + this.address(liveNode));
        this.cache(nodeToKill).stop();
        checkPoint.awaitStrict("IN_RESPONSE_" + this.address(liveNode), 10L, TimeUnit.SECONDS);
        checkPoint.trigger("OUT_RESPONSE_" + this.address(liveNode));
        this.log.debugf("Received segments?", new Object[0]);
        Thread.sleep(1000L);
        checkPoint.awaitStrict("IN_GET_TRANSACTIONS_" + this.address(liveNode), 10L, TimeUnit.SECONDS);
        checkPoint.trigger("OUT_GET_TRANSACTIONS_" + this.address(liveNode));
        checkPoint.awaitStrict("IN_START_STATE_TRANSFER_" + this.address(liveNode), 10L, TimeUnit.SECONDS);
        checkPoint.trigger("OUT_START_STATE_TRANSFER_" + this.address(liveNode));
        checkPoint.awaitStrict("IN_RESPONSE_" + this.address(liveNode), 10L, TimeUnit.SECONDS);
        checkPoint.trigger("OUT_RESPONSE_" + this.address(liveNode));
        TestingUtil.waitForRehashToComplete(this.cache(0), this.cache(liveNode));
        this.log.debugf("Final checkpoint status: %s", (Object)checkPoint);
        DataContainer dataContainer = TestingUtil.extractComponent(this.cache(0), DataContainer.class);
        Assert.assertTrue((boolean)dataContainer.containsKey((Object)k1));
    }

    private void replaceInvocationHandler(final CheckPoint checkPoint, final EmbeddedCacheManager manager, Class<? extends CacheRpcCommand> commandClass) throws Throwable {
        final InboundInvocationHandler handler = TestingUtil.extractGlobalComponent((CacheContainer)manager, InboundInvocationHandler.class);
        InboundInvocationHandler mockHandler = (InboundInvocationHandler)Mockito.mock(InboundInvocationHandler.class);
        Mockito.when((Object)mockHandler.handle((CacheRpcCommand)Matchers.any(commandClass), (Address)Matchers.any(Address.class))).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                CacheRpcCommand command = (CacheRpcCommand)invocation.getArguments()[0];
                Address source = (Address)invocation.getArguments()[1];
                if (command instanceof StateRequestCommand && source.equals(StateResponseOrderingTest.this.address(0))) {
                    StateRequestCommand stateRequestCommand = (StateRequestCommand)command;
                    checkPoint.trigger("IN_" + stateRequestCommand.getType() + '_' + manager.getAddress());
                    checkPoint.awaitStrict("OUT_" + stateRequestCommand.getType() + '_' + manager.getAddress(), 5L, TimeUnit.SECONDS);
                } else if (command instanceof StateResponseCommand && manager.getAddress().equals(StateResponseOrderingTest.this.address(0))) {
                    checkPoint.trigger("IN_RESPONSE_" + source);
                    checkPoint.awaitStrict("OUT_RESPONSE_" + source, 5L, TimeUnit.SECONDS);
                }
                return handler.handle(command, source);
            }
        });
        TestingUtil.replaceComponent((CacheContainer)manager, InboundInvocationHandler.class, mockHandler, true);
        Transport transport = TestingUtil.extractGlobalComponent((CacheContainer)manager, Transport.class);
        CommandAwareRpcDispatcher dispatcher = (CommandAwareRpcDispatcher)TestingUtil.extractField(transport, "dispatcher");
        TestingUtil.replaceField(mockHandler, "inboundInvocationHandler", dispatcher, CommandAwareRpcDispatcher.class);
    }
}

