/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="eviction.BaseEvictionFunctionalTest")
public abstract class BaseEvictionFunctionalTest
extends SingleCacheManagerTest {
    private static final int CACHE_SIZE = 128;

    protected BaseEvictionFunctionalTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected abstract EvictionStrategy getEvictionStrategy();

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
        builder.eviction().maxEntries(128).strategy(this.getEvictionStrategy()).expiration().wakeUpInterval(100L).locking().useLockStriping(false).invocationBatching();
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(builder);
        this.cache = cm.getCache();
        this.cache.addListener((Object)new EvictionListener());
        return cm;
    }

    public void testSimpleEvictionMaxEntries() throws Exception {
        for (int i = 0; i < 256; ++i) {
            this.cache.put((Object)("key-" + (i + 1)), (Object)("value-" + (i + 1)), 1L, TimeUnit.MINUTES);
        }
        Thread.sleep(1000L);
        assert (128 >= this.cache.size()) : "cache size too big: " + this.cache.size();
    }

    public void testSimpleExpirationMaxIdle() throws Exception {
        for (int i = 0; i < 256; ++i) {
            this.cache.put((Object)("key-" + (i + 1)), (Object)("value-" + (i + 1)), 1L, TimeUnit.MILLISECONDS);
        }
        Thread.sleep(1000L);
        assert (0 == this.cache.size()) : "cache size should be zero: " + this.cache.size();
    }

    public void testMultiThreaded() throws InterruptedException {
        int NUM_THREADS = 20;
        Writer[] w = new Writer[NUM_THREADS];
        CountDownLatch startLatch = new CountDownLatch(1);
        for (int i = 0; i < NUM_THREADS; ++i) {
            w[i] = new Writer(i, startLatch);
        }
        for (Writer writer : w) {
            writer.start();
        }
        startLatch.countDown();
        Thread.sleep(250L);
        for (Writer writer : w) {
            writer.running = false;
        }
        for (Writer writer : w) {
            writer.join();
        }
        long giveUpTime = System.currentTimeMillis() + 10000L;
        while (this.cache.getAdvancedCache().getDataContainer().size() > 1 && System.currentTimeMillis() < giveUpTime) {
            Thread.sleep(100L);
        }
        assert (this.cache.getAdvancedCache().getDataContainer().size() <= 128) : "Expected 1, was " + this.cache.size();
    }

    @Listener
    public static class EvictionListener {
        @CacheEntriesEvicted
        public void nodeEvicted(CacheEntriesEvictedEvent e) {
            assert (e.isPre() || !e.isPre());
            Object key = e.getEntries().keySet().iterator().next();
            assert (key != null);
            assert (e.getCache() != null);
            assert (e.getType() == Event.Type.CACHE_ENTRY_EVICTED);
        }
    }

    private class Writer
    extends Thread {
        CountDownLatch startLatch;
        volatile boolean running;
        Random r;

        public Writer(int n, CountDownLatch startLatch) {
            super("Writer-" + n);
            this.running = true;
            this.r = new Random();
            this.startLatch = startLatch;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.startLatch.await();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            while (this.running) {
                try {
                    Writer.sleep(this.r.nextInt(5) * 10);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (Math.random() < 0.5) {
                    BaseEvictionFunctionalTest.this.cache.put((Object)("key" + this.r.nextInt()), (Object)"value");
                    continue;
                }
                BaseEvictionFunctionalTest.this.cache.put((Object)("key" + this.r.nextInt()), (Object)"value", 10L, TimeUnit.SECONDS);
            }
        }
    }
}

