/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.scopes;

import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.ScopeDetector;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="factories.scopes.ScopeDetectorTest")
public class ScopeDetectorTest
extends AbstractInfinispanTest {
    public void testScopeOnClass() {
        this.testScopes(Test1.class, Scopes.GLOBAL);
    }

    public void testScopeOnInterface() {
        this.testScopes(Test2.class, Scopes.GLOBAL);
    }

    public void testScopeOnSuperClass() {
        this.testScopes(Test3.class, Scopes.GLOBAL);
    }

    public void testScopeOnSuperInterface() {
        this.testScopes(Test4.class, Scopes.GLOBAL);
    }

    public void testNoScopes() {
        this.testScopes(Test6.class, Scopes.NAMED_CACHE);
    }

    private void testScopes(Class clazz, Scopes expected) {
        Scopes detected = ScopeDetector.detectScope((Class)clazz);
        assert (detected == expected) : "Expected " + expected + " but was " + detected;
    }

    public static class Test6
    extends SuperUnScoped
    implements Unscoped {
    }

    public static class Test4
    extends Test2 {
    }

    public static class Test3
    extends SuperScoped {
    }

    public static class Test2
    implements Scoped {
    }

    @Scope(value=Scopes.GLOBAL)
    public static class Test1 {
    }

    public static class SuperUnScoped {
    }

    @Scope(value=Scopes.GLOBAL)
    public static class SuperScoped {
    }

    @Scope(value=Scopes.GLOBAL)
    public static interface Scoped {
    }

    public static interface Unscoped {
    }
}

