/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.TestAddress;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ReplicatedConsistentHash;
import org.infinispan.interceptors.ReplicationInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.locks.LockManager;
import org.junit.Assert;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="interceptors.ReplicationInterceptorTest")
public class ReplicationInterceptorTest {
    public void testRemoteGetForGetKeyValueCommand() throws Throwable {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.REPL_SYNC);
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        Configuration configuration = cb.build();
        ReplicationInterceptor replInterceptor = new ReplicationInterceptor();
        CommandInterceptor nextInterceptor = (CommandInterceptor)Mockito.mock(CommandInterceptor.class);
        Mockito.when((Object)nextInterceptor.visitGetKeyValueCommand((InvocationContext)Matchers.any(InvocationContext.class), (GetKeyValueCommand)Matchers.any(GetKeyValueCommand.class))).thenReturn(null);
        replInterceptor.setNext(nextInterceptor);
        CommandsFactory commandsFactory = (CommandsFactory)Mockito.mock(CommandsFactory.class);
        Mockito.when((Object)commandsFactory.buildClusteredGetCommand(Matchers.any(Object.class), (Set)Matchers.any(Set.class), Matchers.anyBoolean(), (GlobalTransaction)Matchers.any(GlobalTransaction.class))).thenAnswer((Answer)new Answer<ClusteredGetCommand>(){

            public ClusteredGetCommand answer(InvocationOnMock invocation) {
                Object key = invocation.getArguments()[0];
                Set flags = (Set)invocation.getArguments()[1];
                boolean acquireRemoteLock = (Boolean)invocation.getArguments()[2];
                GlobalTransaction gtx = (GlobalTransaction)invocation.getArguments()[3];
                return new ClusteredGetCommand(key, "cache1", flags, acquireRemoteLock, gtx);
            }
        });
        EntryFactory entryFactory = (EntryFactory)Mockito.mock(EntryFactory.class);
        DataContainer dataContainer = (DataContainer)Mockito.mock(DataContainer.class);
        LockManager lockManager = (LockManager)Mockito.mock(LockManager.class);
        StateTransferManager stateTransferManager = (StateTransferManager)Mockito.mock(StateTransferManager.class);
        TestAddress A = new TestAddress(0, "A");
        TestAddress B = new TestAddress(1, "B");
        ArrayList<TestAddress> members1 = new ArrayList<TestAddress>();
        ArrayList<TestAddress> members2 = new ArrayList<TestAddress>();
        members1.add(A);
        members2.add(A);
        members2.add(B);
        ReplicatedConsistentHash readCh = new ReplicatedConsistentHash(members1);
        ReplicatedConsistentHash writeCh = new ReplicatedConsistentHash(members2);
        final CacheTopology cacheTopology = new CacheTopology(1, (ConsistentHash)readCh, (ConsistentHash)writeCh);
        Mockito.when((Object)stateTransferManager.getCacheTopology()).thenAnswer((Answer)new Answer<CacheTopology>(){

            public CacheTopology answer(InvocationOnMock invocation) {
                return cacheTopology;
            }
        });
        replInterceptor.injectDependencies(commandsFactory, entryFactory, lockManager, dataContainer, stateTransferManager);
        RpcManager rpcManager = (RpcManager)Mockito.mock(RpcManager.class);
        Transport transport = (Transport)Mockito.mock(Transport.class);
        Mockito.when((Object)rpcManager.getAddress()).thenReturn((Object)B);
        Mockito.when((Object)rpcManager.getTransport()).thenReturn((Object)transport);
        Mockito.when((Object)transport.getMembers()).thenReturn(members2);
        replInterceptor.inject(rpcManager);
        replInterceptor.injectConfiguration(configuration);
        Mockito.when((Object)rpcManager.invokeRemotely((Collection)Matchers.any(Collection.class), (ReplicableCommand)Matchers.any(ClusteredGetCommand.class), (ResponseMode)Matchers.any(ResponseMode.class), Matchers.anyLong(), Matchers.anyBoolean(), (ResponseFilter)Matchers.any(ResponseFilter.class))).thenAnswer((Answer)new Answer<Map<Address, Response>>(){

            public Map<Address, Response> answer(InvocationOnMock invocation) {
                Collection recipients = (Collection)invocation.getArguments()[0];
                ClusteredGetCommand clusteredGetCommand = (ClusteredGetCommand)invocation.getArguments()[1];
                if (clusteredGetCommand.getKey().equals("theKey")) {
                    HashMap<Address, Response> results = new HashMap<Address, Response>();
                    for (Address recipient : recipients) {
                        results.put(recipient, (Response)SuccessfulResponse.create((Object)new ImmortalCacheValue((Object)"theValue")));
                    }
                    return results;
                }
                return Collections.emptyMap();
            }
        });
        InvocationContext ctx = (InvocationContext)Mockito.mock(InvocationContext.class);
        Mockito.when((Object)ctx.isOriginLocal()).thenReturn((Object)true);
        Mockito.when((Object)ctx.isInTxScope()).thenReturn((Object)false);
        GetKeyValueCommand getKeyValueCommand = new GetKeyValueCommand((Object)"theKey", null);
        Object retVal = replInterceptor.visitGetKeyValueCommand(ctx, getKeyValueCommand);
        Assert.assertEquals((Object)"theValue", (Object)retVal);
    }
}

