/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.api.mvcc.LockAssert;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.CacheLoaderFunctionalTest")
public class CacheLoaderFunctionalTest
extends AbstractInfinispanTest {
    private static final Log log = LogFactory.getLog(CacheLoaderFunctionalTest.class);
    Cache cache;
    CacheStore store;
    TransactionManager tm;
    Configuration cfg;
    EmbeddedCacheManager cm;
    long lifespan = 60000000L;

    @BeforeMethod
    public void setUp() {
        this.cfg = new Configuration().fluent().loaders().addCacheLoader(new CacheLoaderConfig[]{new DummyInMemoryCacheStore.Cfg().storeName(this.getClass().getName())}).transaction().transactionMode(TransactionMode.TRANSACTIONAL).build();
        this.cm = TestCacheManagerFactory.createCacheManager(this.cfg);
        this.cache = this.cm.getCache();
        this.store = TestingUtil.extractComponent(this.cache, CacheLoaderManager.class).getCacheStore();
        this.tm = TestingUtil.getTransactionManager(this.cache);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws CacheLoaderException {
        this.store.clear();
        TestingUtil.killCacheManagers(this.cm);
        this.cache = null;
        this.cm = null;
        this.cfg = null;
        this.tm = null;
        this.store = null;
    }

    private void assertInCacheAndStore(Object key, Object value) throws CacheLoaderException {
        this.assertInCacheAndStore(key, value, -1L);
    }

    private void assertInCacheAndStore(Object key, Object value, long lifespanMillis) throws CacheLoaderException {
        this.assertInCacheAndStore(this.cache, this.store, key, value, lifespanMillis);
    }

    private void assertInCacheAndStore(Cache cache, CacheStore store, Object key, Object value) throws CacheLoaderException {
        this.assertInCacheAndStore(cache, store, key, value, -1L);
    }

    private void assertInCacheAndStore(Cache cache, CacheStore store, Object key, Object value, long lifespanMillis) throws CacheLoaderException {
        InternalCacheEntry se = cache.getAdvancedCache().getDataContainer().get(key);
        this.testStoredEntry(se, value, lifespanMillis, "Cache", key);
        se = store.load(key);
        this.testStoredEntry(se, value, lifespanMillis, "Store", key);
    }

    private void testStoredEntry(InternalCacheEntry entry, Object expectedValue, long expectedLifespan, String src, Object key) {
        assert (entry != null) : src + " entry for key " + key + " should NOT be null";
        assert (entry.getValue().equals(expectedValue)) : src + " should contain value " + expectedValue + " under key " + entry.getKey() + " but was " + entry.getValue() + ". Entry is " + entry;
        assert (entry.getLifespan() == expectedLifespan) : src + " expected lifespan for key " + key + " to be " + expectedLifespan + " but was " + entry.getLifespan() + ". Entry is " + entry;
    }

    private void assertNotInCacheAndStore(Cache cache, CacheStore store, Object ... keys) throws CacheLoaderException {
        for (Object key : keys) {
            assert (!cache.getAdvancedCache().getDataContainer().containsKey(key)) : "Cache should not contain key " + key;
            assert (!store.containsKey(key)) : "Store should not contain key " + key;
        }
    }

    private void assertNotInCacheAndStore(Object ... keys) throws CacheLoaderException {
        this.assertNotInCacheAndStore(this.cache, this.store, keys);
    }

    private void assertInStoreNotInCache(Object ... keys) throws CacheLoaderException {
        this.assertInStoreNotInCache(this.cache, this.store, keys);
    }

    private void assertInStoreNotInCache(Cache cache, CacheStore store, Object ... keys) throws CacheLoaderException {
        for (Object key : keys) {
            assert (!cache.getAdvancedCache().getDataContainer().containsKey(key)) : "Cache should not contain key " + key;
            assert (store.containsKey(key)) : "Store should contain key " + key;
        }
    }

    private void assertInCacheAndNotInStore(Object ... keys) throws CacheLoaderException {
        this.assertInCacheAndNotInStore(this.cache, this.store, keys);
    }

    private void assertInCacheAndNotInStore(Cache cache, CacheStore store, Object ... keys) throws CacheLoaderException {
        for (Object key : keys) {
            assert (cache.getAdvancedCache().getDataContainer().containsKey(key)) : "Cache should not contain key " + key;
            assert (!store.containsKey(key)) : "Store should contain key " + key;
        }
    }

    public void testStoreAndRetrieve() throws CacheLoaderException {
        int i;
        this.assertNotInCacheAndStore("k1", "k2", "k3", "k4", "k5", "k6", "k7");
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        this.cache.putAll(Collections.singletonMap("k3", "v3"));
        this.cache.putAll(Collections.singletonMap("k4", "v4"), this.lifespan, TimeUnit.MILLISECONDS);
        this.cache.putIfAbsent((Object)"k5", (Object)"v5");
        this.cache.putIfAbsent((Object)"k6", (Object)"v6", this.lifespan, TimeUnit.MILLISECONDS);
        this.cache.putIfAbsent((Object)"k5", (Object)"v5-SHOULD-NOT-PUT");
        this.cache.putIfAbsent((Object)"k6", (Object)"v6-SHOULD-NOT-PUT", this.lifespan, TimeUnit.MILLISECONDS);
        this.cache.putForExternalRead((Object)"k7", (Object)"v7");
        this.cache.putForExternalRead((Object)"k7", (Object)"v7-SHOULD-NOT-PUT");
        for (i = 1; i < 8; ++i) {
            if (i % 2 == 1) {
                this.assertInCacheAndStore("k" + i, "v" + i);
                continue;
            }
            this.assertInCacheAndStore("k" + i, "v" + i, this.lifespan);
        }
        assert (!this.cache.remove((Object)"k1", (Object)"some rubbish"));
        for (i = 1; i < 8; ++i) {
            if (i % 2 == 1) {
                this.assertInCacheAndStore("k" + i, "v" + i);
                continue;
            }
            this.assertInCacheAndStore("k" + i, "v" + i, this.lifespan);
        }
        log.info((Object)("cache.get(\"k1\") = " + this.cache.get((Object)"k1")));
        assert (this.cache.remove((Object)"k1", (Object)"v1"));
        log.info((Object)("cache.get(\"k1\") = " + this.cache.get((Object)"k1")));
        assert (this.cache.remove((Object)"k2").equals("v2"));
        this.assertNotInCacheAndStore("k1", "k2");
        for (i = 3; i < 8; ++i) {
            if (i % 2 == 1) {
                this.assertInCacheAndStore("k" + i, "v" + i);
                continue;
            }
            this.assertInCacheAndStore("k" + i, "v" + i, this.lifespan);
        }
        this.cache.clear();
        this.assertNotInCacheAndStore("k1", "k2", "k3", "k4", "k5", "k6", "k7");
    }

    public void testReplaceMethods() throws CacheLoaderException {
        int i;
        this.assertNotInCacheAndStore("k1", "k2", "k3", "k4");
        this.cache.replace((Object)"k1", (Object)"v1-SHOULD-NOT-STORE");
        LockAssert.assertNoLocks(this.cache);
        this.cache.replace((Object)"k2", (Object)"v2-SHOULD-NOT-STORE", this.lifespan, TimeUnit.MILLISECONDS);
        LockAssert.assertNoLocks(this.cache);
        this.assertNotInCacheAndStore("k1", "k2", "k3", "k4");
        this.cache.put((Object)"k1", (Object)"v1");
        LockAssert.assertNoLocks(this.cache);
        this.cache.put((Object)"k2", (Object)"v2");
        LockAssert.assertNoLocks(this.cache);
        this.cache.put((Object)"k3", (Object)"v3");
        LockAssert.assertNoLocks(this.cache);
        this.cache.put((Object)"k4", (Object)"v4");
        LockAssert.assertNoLocks(this.cache);
        for (i = 1; i < 5; ++i) {
            this.assertInCacheAndStore("k" + i, "v" + i);
        }
        this.cache.replace((Object)"k1", (Object)"v1-SHOULD-NOT-STORE", (Object)"v1-STILL-SHOULD-NOT-STORE");
        LockAssert.assertNoLocks(this.cache);
        this.cache.replace((Object)"k2", (Object)"v2-SHOULD-NOT-STORE", (Object)"v2-STILL-SHOULD-NOT-STORE", this.lifespan, TimeUnit.MILLISECONDS);
        LockAssert.assertNoLocks(this.cache);
        for (i = 1; i < 5; ++i) {
            this.assertInCacheAndStore("k" + i, "v" + i);
        }
        this.cache.replace((Object)"k1", (Object)"v1-REPLACED");
        LockAssert.assertNoLocks(this.cache);
        this.cache.replace((Object)"k2", (Object)"v2-REPLACED", this.lifespan, TimeUnit.MILLISECONDS);
        this.assertInCacheAndStore("k2", "v2-REPLACED", this.lifespan);
        LockAssert.assertNoLocks(this.cache);
        this.cache.replace((Object)"k3", (Object)"v3", (Object)"v3-REPLACED");
        LockAssert.assertNoLocks(this.cache);
        this.cache.replace((Object)"k4", (Object)"v4", (Object)"v4-REPLACED", this.lifespan, TimeUnit.MILLISECONDS);
        LockAssert.assertNoLocks(this.cache);
        for (i = 1; i < 5; ++i) {
            if (i % 2 == 1) {
                this.assertInCacheAndStore("k" + i, "v" + i + "-REPLACED");
                continue;
            }
            this.assertInCacheAndStore("k" + i, "v" + i + "-REPLACED", this.lifespan);
        }
        LockAssert.assertNoLocks(this.cache);
    }

    public void testLoading() throws CacheLoaderException {
        int i;
        this.assertNotInCacheAndStore("k1", "k2", "k3", "k4");
        for (i = 1; i < 5; ++i) {
            this.store.store(TestInternalCacheEntryFactory.create("k" + i, "v" + i));
        }
        for (i = 1; i < 5; ++i) {
            assert (this.cache.get((Object)("k" + i)).equals("v" + i));
        }
        LockAssert.assertNoLocks(this.cache);
        for (i = 1; i < 5; ++i) {
            this.cache.evict((Object)("k" + i));
        }
        LockAssert.assertNoLocks(this.cache);
        assert (this.cache.putIfAbsent((Object)"k1", (Object)"v1-SHOULD-NOT-STORE").equals("v1"));
        assert (this.cache.remove((Object)"k2").equals("v2"));
        assert (this.cache.replace((Object)"k3", (Object)"v3-REPLACED").equals("v3"));
        assert (this.cache.replace((Object)"k4", (Object)"v4", (Object)"v4-REPLACED"));
        LockAssert.assertNoLocks(this.cache);
        assert (this.cache.size() == 3) : "Expected the cache to contain 3 elements but contained " + this.cache.entrySet();
        for (i = 1; i < 5; ++i) {
            this.cache.evict((Object)("k" + i));
        }
        LockAssert.assertNoLocks(this.cache);
        assert (this.cache.isEmpty());
        this.cache.clear();
        this.assertNotInCacheAndStore("k1", "k2", "k3", "k4");
        LockAssert.assertNoLocks(this.cache);
    }

    public void testPreloading() throws CacheLoaderException {
        Configuration preloadingCfg = this.cfg.clone();
        preloadingCfg.getCacheLoaderManagerConfig().setPreload(Boolean.valueOf(true));
        ((DummyInMemoryCacheStore.Cfg)preloadingCfg.getCacheLoaderManagerConfig().getFirstCacheLoaderConfig()).setStoreName("preloadingCache");
        this.cm.defineConfiguration("preloadingCache", preloadingCfg);
        Cache preloadingCache = this.cm.getCache("preloadingCache");
        CacheStore preloadingStore = TestingUtil.extractComponent(preloadingCache, CacheLoaderManager.class).getCacheStore();
        assert (preloadingCache.getConfiguration().getCacheLoaderManagerConfig().isPreload().booleanValue());
        this.assertNotInCacheAndStore(preloadingCache, preloadingStore, new Object[]{"k1", "k2", "k3", "k4"});
        preloadingCache.put((Object)"k1", (Object)"v1");
        preloadingCache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        preloadingCache.put((Object)"k3", (Object)"v3");
        preloadingCache.put((Object)"k4", (Object)"v4", this.lifespan, TimeUnit.MILLISECONDS);
        for (int i = 1; i < 5; ++i) {
            if (i % 2 == 1) {
                this.assertInCacheAndStore(preloadingCache, preloadingStore, "k" + i, "v" + i);
                continue;
            }
            this.assertInCacheAndStore(preloadingCache, preloadingStore, "k" + i, "v" + i, this.lifespan);
        }
        DataContainer c = preloadingCache.getAdvancedCache().getDataContainer();
        assert (c.size() == 4);
        preloadingCache.stop();
        assert (c.size() == 0);
        preloadingCache.start();
        preloadingStore = TestingUtil.extractComponent(preloadingCache, CacheLoaderManager.class).getCacheStore();
        assert (preloadingCache.getConfiguration().getCacheLoaderManagerConfig().isPreload().booleanValue());
        c = preloadingCache.getAdvancedCache().getDataContainer();
        assert (c.size() == 4);
        for (int i = 1; i < 5; ++i) {
            if (i % 2 == 1) {
                this.assertInCacheAndStore(preloadingCache, preloadingStore, "k" + i, "v" + i);
                continue;
            }
            this.assertInCacheAndStore(preloadingCache, preloadingStore, "k" + i, "v" + i, this.lifespan);
        }
    }

    public void testPurgeOnStartup() throws CacheLoaderException {
        Configuration purgingCfg = this.cfg.clone();
        CacheStoreConfig firstCacheLoaderConfig = (CacheStoreConfig)purgingCfg.getCacheLoaderManagerConfig().getFirstCacheLoaderConfig();
        firstCacheLoaderConfig.setPurgeOnStartup(Boolean.valueOf(true));
        ((DummyInMemoryCacheStore.Cfg)purgingCfg.getCacheLoaderManagerConfig().getFirstCacheLoaderConfig()).setStoreName("purgingCache");
        this.cm.defineConfiguration("purgingCache", purgingCfg);
        Cache purgingCache = this.cm.getCache("purgingCache");
        CacheStore purgingStore = TestingUtil.extractComponent(purgingCache, CacheLoaderManager.class).getCacheStore();
        this.assertNotInCacheAndStore(purgingCache, purgingStore, new Object[]{"k1", "k2", "k3", "k4"});
        purgingCache.put((Object)"k1", (Object)"v1");
        purgingCache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        purgingCache.put((Object)"k3", (Object)"v3");
        purgingCache.put((Object)"k4", (Object)"v4", this.lifespan, TimeUnit.MILLISECONDS);
        for (int i = 1; i < 5; ++i) {
            if (i % 2 == 1) {
                this.assertInCacheAndStore(purgingCache, purgingStore, "k" + i, "v" + i);
                continue;
            }
            this.assertInCacheAndStore(purgingCache, purgingStore, "k" + i, "v" + i, this.lifespan);
        }
        DataContainer c = purgingCache.getAdvancedCache().getDataContainer();
        assert (c.size() == 4);
        purgingCache.stop();
        assert (c.size() == 0);
        purgingCache.start();
        c = purgingCache.getAdvancedCache().getDataContainer();
        assert (c.size() == 0);
        this.assertNotInCacheAndStore(purgingCache, purgingStore, new Object[]{"k1", "k2", "k3", "k4"});
    }

    public void testTransactionalWrites() throws Exception {
        assert (this.cache.getStatus() == ComponentStatus.RUNNING);
        this.assertNotInCacheAndStore("k1", "k2");
        this.tm.begin();
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        Transaction t = this.tm.suspend();
        this.assertNotInCacheAndStore("k1", "k2");
        this.tm.resume(t);
        this.tm.commit();
        this.assertInCacheAndStore("k1", "v1");
        this.assertInCacheAndStore("k2", "v2", this.lifespan);
        this.tm.begin();
        this.cache.clear();
        t = this.tm.suspend();
        this.assertInCacheAndStore("k1", "v1");
        this.assertInCacheAndStore("k2", "v2", this.lifespan);
        this.tm.resume(t);
        this.tm.commit();
        this.assertNotInCacheAndStore("k1", "k2");
        this.tm.begin();
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        t = this.tm.suspend();
        this.assertNotInCacheAndStore("k1", "k2");
        this.tm.resume(t);
        this.tm.rollback();
        this.assertNotInCacheAndStore("k1", "k2");
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        this.assertInCacheAndStore("k1", "v1");
        this.assertInCacheAndStore("k2", "v2", this.lifespan);
        this.tm.begin();
        this.cache.clear();
        t = this.tm.suspend();
        this.assertInCacheAndStore("k1", "v1");
        this.assertInCacheAndStore("k2", "v2", this.lifespan);
        this.tm.resume(t);
        this.tm.rollback();
        this.assertInCacheAndStore("k1", "v1");
        this.assertInCacheAndStore("k2", "v2", this.lifespan);
    }

    public void testTransactionalReplace(Method m) throws Exception {
        assert (this.cache.getStatus() == ComponentStatus.RUNNING);
        this.assertNotInCacheAndStore(TestingUtil.k(m, 1));
        this.assertNotInCacheAndStore(TestingUtil.k(m, 2));
        this.cache.put((Object)TestingUtil.k(m, 2), (Object)TestingUtil.v(m));
        this.tm.begin();
        this.cache.put((Object)TestingUtil.k(m, 1), (Object)TestingUtil.v(m, 1));
        this.cache.replace((Object)TestingUtil.k(m, 2), (Object)TestingUtil.v(m, 1));
        Transaction t = this.tm.suspend();
        this.assertNotInCacheAndStore(TestingUtil.k(m, 1));
        this.assertInCacheAndStore(TestingUtil.k(m, 2), TestingUtil.v(m));
        this.tm.resume(t);
        this.tm.commit();
        this.assertInCacheAndStore(TestingUtil.k(m, 1), TestingUtil.v(m, 1));
        this.assertInCacheAndStore(TestingUtil.k(m, 2), TestingUtil.v(m, 1));
    }

    public void testEvictAndRemove() throws CacheLoaderException {
        this.assertNotInCacheAndStore("k1", "k2");
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        this.cache.evict((Object)"k1");
        this.cache.evict((Object)"k2");
        assert ("v1".equals(this.cache.remove((Object)"k1")));
        assert ("v2".equals(this.cache.remove((Object)"k2")));
    }

    public void testLoadingToMemory() throws CacheLoaderException {
        this.assertNotInCacheAndStore("k1", "k2");
        this.store.store(TestInternalCacheEntryFactory.create("k1", "v1"));
        this.store.store(TestInternalCacheEntryFactory.create("k2", "v2"));
        this.assertInStoreNotInCache("k1", "k2");
        assert ("v1".equals(this.cache.get((Object)"k1")));
        assert ("v2".equals(this.cache.get((Object)"k2")));
        this.assertInCacheAndStore("k1", "v1");
        this.assertInCacheAndStore("k2", "v2");
        this.store.remove((Object)"k1");
        this.store.remove((Object)"k2");
        this.assertInCacheAndNotInStore("k1", "k2");
        assert ("v1".equals(this.cache.get((Object)"k1")));
        assert ("v2".equals(this.cache.get((Object)"k2")));
    }

    public void testSkipLocking(Method m) {
        String name = m.getName();
        AdvancedCache advancedCache = this.cache.getAdvancedCache();
        advancedCache.put((Object)("k-" + name), (Object)("v-" + name));
        advancedCache.withFlags(new Flag[]{Flag.SKIP_LOCKING}).put((Object)("k-" + name), (Object)("v2-" + name));
    }

    public void testDuplicatePersistence(Method m) throws Exception {
        String key = "k-" + m.getName();
        String value = "v-" + m.getName();
        this.cache.put((Object)key, (Object)value);
        assert (value.equals(this.cache.get((Object)key)));
        this.cache.stop();
        this.cache.start();
        this.tm.begin();
        this.cache.containsKey((Object)key);
        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}).get((Object)key);
        this.cache.put((Object)key, (Object)value);
        this.tm.commit();
        assert (value.equals(this.cache.get((Object)key)));
    }

    public void testGetCacheLoadersFromConfigAfterStart() {
        this.cache.getConfiguration().getCacheLoaders();
        this.cache.getConfiguration().getCacheLoaders();
    }
}

