/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.testng.annotations.Test;

@Test(testName="loaders.ReadOnlyCacheStoreTest", groups={"functional"}, sequential=true)
@CleanupAfterMethod
public class ReadOnlyCacheStoreTest
extends SingleCacheManagerTest {
    CacheStore store;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration cfg = this.getDefaultStandaloneConfig(true);
        cfg.setInvocationBatchingEnabled(true);
        CacheLoaderManagerConfig clmc = new CacheLoaderManagerConfig();
        clmc.addCacheLoaderConfig((CacheLoaderConfig)new DummyInMemoryCacheStore.Cfg().ignoreModifications(true));
        cfg.setCacheLoaderManagerConfig(clmc);
        return TestCacheManagerFactory.createCacheManager(cfg);
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        this.store = TestingUtil.extractComponent(this.cache, CacheLoaderManager.class).getCacheStore();
    }

    public void testReadOnlyCacheStore() throws CacheLoaderException {
        this.store.store(TestInternalCacheEntryFactory.create("k1", "v1"));
        this.store.store(TestInternalCacheEntryFactory.create("k2", "v2"));
        assert (!this.store.containsKey((Object)"k1")) : "READ ONLY - Store should NOT contain k1 key.";
        assert (!this.store.containsKey((Object)"k2")) : "READ ONLY - Store should NOT contain k2 key.";
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2");
        assert ("v1".equals(this.cache.get((Object)"k1")));
        assert ("v2".equals(this.cache.get((Object)"k2")));
        assert (!this.store.containsKey((Object)"k1")) : "READ ONLY - Store should NOT contain k1 key.";
        assert (!this.store.containsKey((Object)"k2")) : "READ ONLY - Store should NOT contain k2 key.";
        assert (!this.store.remove((Object)"k1")) : "READ ONLY - Remove operation should return false (no op)";
        assert (!this.store.remove((Object)"k2")) : "READ ONLY - Remove operation should return false (no op)";
        assert (!this.store.remove((Object)"k3")) : "READ ONLY - Remove operation should return false (no op)";
        assert ("v1".equals(this.cache.get((Object)"k1")));
        assert ("v2".equals(this.cache.get((Object)"k2")));
        this.cache.remove((Object)"k1");
        this.cache.remove((Object)"k2");
        assert (this.cache.get((Object)"k1") == null);
        assert (this.cache.get((Object)"k2") == null);
    }
}

