/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.decorators;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderMetadata;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.decorators.AsyncStore;
import org.infinispan.loaders.decorators.AsyncStoreConfig;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.loaders.modifications.Clear;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.loaders.modifications.Remove;
import org.infinispan.loaders.modifications.Store;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.decorators.AsyncStoreTest", sequential=true)
public class AsyncStoreTest
extends AbstractInfinispanTest {
    private static final Log log = LogFactory.getLog(AsyncStoreTest.class);
    AsyncStore store;
    ExecutorService asyncExecutor;
    DummyInMemoryCacheStore underlying;
    AsyncStoreConfig asyncConfig;
    DummyInMemoryCacheStore.Cfg dummyCfg;
    private static final ThreadLocal<LockableCacheStore> STORE = new ThreadLocal();

    @BeforeMethod
    public void setUp() throws CacheLoaderException {
        this.underlying = new DummyInMemoryCacheStore();
        this.asyncConfig = new AsyncStoreConfig().threadPoolSize(Integer.valueOf(10));
        this.store = new AsyncStore((CacheStore)this.underlying, this.asyncConfig);
        this.dummyCfg = new DummyInMemoryCacheStore.Cfg().storeName(AsyncStoreTest.class.getName());
        this.store.init((CacheLoaderConfig)this.dummyCfg, null, null);
        this.store.start();
        this.asyncExecutor = (ExecutorService)TestingUtil.extractField(this.store, "executor");
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws CacheLoaderException {
        if (this.store != null) {
            this.store.stop();
        }
    }

    @Test(timeOut=10000L)
    public void testPutRemove() throws Exception {
        TestCacheManagerFactory.backgroundTestStarted(this);
        int number = 1000;
        String key = "testPutRemove-k-";
        String value = "testPutRemove-v-";
        this.doTestPut(1000, key, value);
        this.doTestRemove(1000, key);
    }

    @Test(timeOut=10000L)
    public void testPutClearPut() throws Exception {
        TestCacheManagerFactory.backgroundTestStarted(this);
        int number = 1000;
        String key = "testPutClearPut-k-";
        String value = "testPutClearPut-v-";
        this.doTestPut(1000, key, value);
        this.doTestClear(1000, key);
        value = "testPutClearPut-v[2]-";
        this.doTestPut(1000, key, value);
        this.doTestRemove(1000, key);
    }

    @Test(timeOut=10000L)
    public void testMultiplePutsOnSameKey() throws Exception {
        TestCacheManagerFactory.backgroundTestStarted(this);
        int number = 1000;
        String key = "testMultiplePutsOnSameKey-k";
        String value = "testMultiplePutsOnSameKey-v-";
        this.doTestSameKeyPut(1000, key, value);
        this.doTestSameKeyRemove(key);
    }

    @Test(timeOut=10000L)
    public void testRestrictionOnAddingToAsyncQueue() throws Exception {
        TestCacheManagerFactory.backgroundTestStarted(this);
        this.store.remove((Object)"blah");
        int number = 10;
        String key = "testRestrictionOnAddingToAsyncQueue-k";
        String value = "testRestrictionOnAddingToAsyncQueue-v-";
        this.doTestPut(10, key, value);
        this.store.stop();
        try {
            this.store.store(null);
            assert (false) : "Should have restricted this entry from being made";
        }
        catch (CacheException expected) {
            // empty catch block
        }
        this.store.start();
        this.doTestRemove(10, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testThreadSafetyWritingDiffValuesForKey(Method m) throws Exception {
        try {
            String key = "k1";
            CountDownLatch v1Latch = new CountDownLatch(1);
            CountDownLatch v2Latch = new CountDownLatch(1);
            CountDownLatch endLatch = new CountDownLatch(1);
            DummyInMemoryCacheStore underlying = new DummyInMemoryCacheStore();
            this.store = new MockAsyncStore("k1", v1Latch, v2Latch, endLatch, (CacheStore)underlying, this.asyncConfig);
            this.dummyCfg = new DummyInMemoryCacheStore.Cfg();
            this.dummyCfg.setStoreName(m.getName());
            this.store.init((CacheLoaderConfig)this.dummyCfg, null, null);
            this.store.start();
            this.store.store(TestInternalCacheEntryFactory.create("k1", "v1"));
            v2Latch.await();
            this.store.store(TestInternalCacheEntryFactory.create("k1", "v2"));
            endLatch.await();
            assert (this.store.load((Object)"k1").getValue().equals("v2"));
        }
        finally {
            this.store.delegate.clear();
            this.store.stop();
            this.store = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionalModificationsHappenInDiffThread(Method m) throws Exception {
        int waitTimeout = 10;
        final TimeUnit waitUnit = TimeUnit.SECONDS;
        try {
            TransactionFactory gtf = new TransactionFactory();
            gtf.init(false, false, true, false);
            String k1 = TestingUtil.k(m, 1);
            String k2 = TestingUtil.k(m, 2);
            String v1 = TestingUtil.v(m, 1);
            String v2 = TestingUtil.v(m, 2);
            final ConcurrentHashMap localMods = new ConcurrentHashMap();
            final CyclicBarrier barrier = new CyclicBarrier(2);
            DummyInMemoryCacheStore underlying = new DummyInMemoryCacheStore();
            this.store = new AsyncStore((CacheStore)underlying, this.asyncConfig){

                protected void applyModificationsSync(List<Modification> mods) throws CacheLoaderException {
                    for (Modification mod : mods) {
                        localMods.put(this.getKey(mod), mod);
                    }
                    super.applyModificationsSync(mods);
                    try {
                        barrier.await(10L, waitUnit);
                    }
                    catch (TimeoutException e) {
                        assert (false) : "Timed out applying for modifications";
                    }
                    catch (Exception e) {
                        throw new CacheLoaderException("Barrier failed", (Throwable)e);
                    }
                }

                private Object getKey(Modification modification) {
                    switch (modification.getType()) {
                        case STORE: {
                            return ((Store)modification).getStoredEntry().getKey();
                        }
                        case REMOVE: {
                            return ((Remove)modification).getKey();
                        }
                    }
                    return null;
                }
            };
            this.dummyCfg = new DummyInMemoryCacheStore.Cfg();
            this.dummyCfg.setStoreName(m.getName());
            this.store.init((CacheLoaderConfig)this.dummyCfg, null, null);
            this.store.start();
            ArrayList<Object> mods = new ArrayList<Object>();
            mods.add(new Store(TestInternalCacheEntryFactory.create(k1, v1)));
            mods.add(new Store(TestInternalCacheEntryFactory.create(k2, v2)));
            mods.add(new Remove((Object)k1));
            GlobalTransaction tx = gtf.newGlobalTransaction(null, false);
            this.store.prepare(mods, tx, false);
            assert (0 == localMods.size());
            assert (!this.store.containsKey((Object)k1));
            assert (!this.store.containsKey((Object)k2));
            this.store.commit(tx);
            barrier.await(10L, waitUnit);
            barrier.await(10L, waitUnit);
            assert (this.store.load((Object)k2).getValue().equals(v2));
            assert (!this.store.containsKey((Object)k1));
            assert (2 == localMods.size());
            assert (new Remove((Object)k1).equals(localMods.get(k1)));
        }
        finally {
            this.store.delegate.clear();
            this.store.stop();
            this.store = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionalModificationsAreCoalesced(Method m) throws Exception {
        int waitTimeout = 10;
        final TimeUnit waitUnit = TimeUnit.SECONDS;
        try {
            TransactionFactory gtf = new TransactionFactory();
            gtf.init(false, false, true, false);
            String k1 = TestingUtil.k(m, 1);
            String k2 = TestingUtil.k(m, 2);
            String k3 = TestingUtil.k(m, 3);
            String v1 = TestingUtil.v(m, 1);
            String v2 = TestingUtil.v(m, 2);
            String v3 = TestingUtil.v(m, 3);
            final AtomicInteger storeCount = new AtomicInteger();
            final AtomicInteger removeCount = new AtomicInteger();
            final AtomicInteger clearCount = new AtomicInteger();
            final CyclicBarrier barrier = new CyclicBarrier(2);
            DummyInMemoryCacheStore underlying = new DummyInMemoryCacheStore(){

                @Override
                public void store(InternalCacheEntry ed) {
                    super.store(ed);
                    storeCount.getAndIncrement();
                }

                @Override
                public boolean remove(Object key) {
                    boolean ret = super.remove(key);
                    removeCount.getAndIncrement();
                    return ret;
                }

                @Override
                public void clear() {
                    super.clear();
                    clearCount.getAndIncrement();
                }
            };
            this.store = new AsyncStore((CacheStore)underlying, this.asyncConfig){

                protected void applyModificationsSync(List<Modification> mods) throws CacheLoaderException {
                    super.applyModificationsSync(mods);
                    try {
                        log.tracef("Wait to apply modifications: %s", mods);
                        barrier.await(10L, waitUnit);
                    }
                    catch (TimeoutException e) {
                        assert (false) : "Timed out applying for modifications";
                    }
                    catch (Exception e) {
                        throw new CacheLoaderException("Barrier failed", (Throwable)e);
                    }
                }
            };
            this.dummyCfg = new DummyInMemoryCacheStore.Cfg();
            this.dummyCfg.setStoreName(m.getName());
            this.store.init((CacheLoaderConfig)this.dummyCfg, null, null);
            this.store.start();
            ArrayList<Object> mods = new ArrayList<Object>();
            mods.add(new Store(TestInternalCacheEntryFactory.create(k1, v1)));
            mods.add(new Store(TestInternalCacheEntryFactory.create(k1, v2)));
            mods.add(new Store(TestInternalCacheEntryFactory.create(k2, v1)));
            mods.add(new Store(TestInternalCacheEntryFactory.create(k2, v2)));
            mods.add(new Remove((Object)k1));
            GlobalTransaction tx = gtf.newGlobalTransaction(null, false);
            this.store.prepare(mods, tx, false);
            Thread.sleep(200L);
            assert (0 == storeCount.get());
            assert (0 == removeCount.get());
            assert (0 == clearCount.get());
            this.store.commit(tx);
            log.tracef("Wait for modifications to be queued: %s", mods);
            barrier.await(10L, waitUnit);
            barrier.await(10L, waitUnit);
            assert (1 == storeCount.get()) : "Store count was " + storeCount.get();
            assert (1 == removeCount.get());
            assert (0 == clearCount.get());
            storeCount.set(0);
            removeCount.set(0);
            clearCount.set(0);
            mods = new ArrayList();
            mods.add(new Store(TestInternalCacheEntryFactory.create(k1, v1)));
            mods.add(new Remove((Object)k1));
            mods.add(new Clear());
            mods.add(new Store(TestInternalCacheEntryFactory.create(k2, v2)));
            mods.add(new Remove((Object)k2));
            tx = gtf.newGlobalTransaction(null, false);
            this.store.prepare(mods, tx, false);
            Thread.sleep(200L);
            assert (0 == storeCount.get());
            assert (0 == removeCount.get());
            assert (0 == clearCount.get());
            this.store.commit(tx);
            barrier.await(10L, waitUnit);
            assert (0 == storeCount.get()) : "Store count was " + storeCount.get();
            assert (1 == removeCount.get());
            assert (1 == clearCount.get());
            storeCount.set(0);
            removeCount.set(0);
            clearCount.set(0);
            mods = new ArrayList();
            mods.add(new Store(TestInternalCacheEntryFactory.create(k1, v1)));
            mods.add(new Remove((Object)k1));
            mods.add(new Store(TestInternalCacheEntryFactory.create(k2, v2)));
            mods.add(new Remove((Object)k2));
            mods.add(new Store(TestInternalCacheEntryFactory.create(k3, v3)));
            tx = gtf.newGlobalTransaction(null, false);
            this.store.prepare(mods, tx, false);
            Thread.sleep(200L);
            assert (0 == storeCount.get());
            assert (0 == removeCount.get());
            assert (0 == clearCount.get());
            this.store.commit(tx);
            barrier.await(10L, waitUnit);
            barrier.await(10L, waitUnit);
            barrier.await(10L, waitUnit);
            assert (1 == storeCount.get()) : "Store count was " + storeCount.get();
            assert (2 == removeCount.get());
            assert (0 == clearCount.get());
            storeCount.set(0);
            removeCount.set(0);
            clearCount.set(0);
            mods = new ArrayList();
            mods.add(new Clear());
            mods.add(new Remove((Object)k1));
            tx = gtf.newGlobalTransaction(null, false);
            this.store.prepare(mods, tx, false);
            Thread.sleep(200L);
            assert (0 == storeCount.get());
            assert (0 == removeCount.get());
            assert (0 == clearCount.get());
            this.store.commit(tx);
            barrier.await(10L, waitUnit);
            assert (0 == storeCount.get()) : "Store count was " + storeCount.get();
            assert (1 == removeCount.get());
            assert (1 == clearCount.get());
            storeCount.set(0);
            removeCount.set(0);
            clearCount.set(0);
            mods = new ArrayList();
            mods.add(new Clear());
            mods.add(new Store(TestInternalCacheEntryFactory.create(k1, v1)));
            tx = gtf.newGlobalTransaction(null, false);
            this.store.prepare(mods, tx, false);
            Thread.sleep(200L);
            assert (0 == storeCount.get());
            assert (0 == removeCount.get());
            assert (0 == clearCount.get());
            this.store.commit(tx);
            barrier.await(10L, waitUnit);
            assert (1 == storeCount.get()) : "Store count was " + storeCount.get();
            assert (0 == removeCount.get());
            assert (1 == clearCount.get());
        }
        finally {
            this.store.delegate.clear();
            this.store.stop();
            this.store = null;
        }
    }

    private void doTestPut(int number, String key, String value) throws Exception {
        int i;
        for (i = 0; i < number; ++i) {
            InternalCacheEntry cacheEntry = TestInternalCacheEntryFactory.create(key + i, value + i);
            this.store.store(cacheEntry);
        }
        for (i = 0; i < number; ++i) {
            InternalCacheEntry ice = this.store.load((Object)(key + i));
            assert (ice != null && (value + i).equals(ice.getValue()));
        }
    }

    private void doTestSameKeyPut(int number, String key, String value) throws Exception {
        for (int i = 0; i < number; ++i) {
            this.store.store(TestInternalCacheEntryFactory.create(key, value + i));
        }
        InternalCacheEntry ice = this.store.load((Object)key);
        assert (ice != null && (value + (number - 1)).equals(ice.getValue()));
    }

    private void doTestRemove(int number, String key) throws Exception {
        int i;
        for (i = 0; i < number; ++i) {
            this.store.remove((Object)(key + i));
        }
        for (i = 0; i < number; ++i) {
            String loadKey = key + i;
            assert (this.store.load((Object)loadKey) == null) : loadKey + " still in store";
        }
    }

    private void doTestSameKeyRemove(String key) throws Exception {
        this.store.remove((Object)key);
        assert (this.store.load((Object)key) == null);
    }

    private void doTestClear(int number, String key) throws Exception {
        this.store.clear();
        for (int i = 0; i < number; ++i) {
            assert (this.store.load((Object)(key + i)) == null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testModificationQueueSize(final Method m) throws Exception {
        LockableCacheStore underlying = new LockableCacheStore();
        this.asyncConfig.modificationQueueSize(Integer.valueOf(10));
        this.store = new AsyncStore((CacheStore)underlying, this.asyncConfig);
        this.store.init((CacheLoaderConfig)new LockableCacheStoreConfig(), null, null);
        this.store.start();
        try {
            final CountDownLatch done = new CountDownLatch(1);
            underlying.lock.lock();
            try {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        try {
                            for (int i = 0; i < 100; ++i) {
                                AsyncStoreTest.this.store.store(TestInternalCacheEntryFactory.create(TestingUtil.k(m, i), TestingUtil.v(m, i)));
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)"Error storing entry", (Throwable)e);
                        }
                        done.countDown();
                    }
                };
                t.start();
                assert (!done.await(1L, TimeUnit.SECONDS)) : "Background thread should have blocked after adding 10 entries";
            }
            finally {
                underlying.lock.unlock();
            }
        }
        finally {
            this.store.stop();
        }
    }

    public void testEndToEndPutPutPassivation() throws Exception {
        this.doTestEndToEndPutPut(true);
    }

    public void testEndToEndPutPut() throws Exception {
        this.doTestEndToEndPutPut(false);
    }

    private void doTestEndToEndPutPut(boolean passivation) throws Exception {
        TestingUtil.withCacheManager(new OneEntryCacheManagerCallable(passivation){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void call() {
                this.cache.put((Object)"X", (Object)"1");
                this.cache.put((Object)"Y", (Object)"1");
                while (this.store.load("X") == null) {
                    TestingUtil.sleepThread(10L);
                }
                this.store.lock.lock();
                try {
                    this.cache.put((Object)"X", (Object)"2");
                    this.cache.put((Object)"Y", (Object)"2");
                    assert ("2".equals(this.cache.get((Object)"X"))) : "cache must return X == 2";
                }
                finally {
                    this.store.lock.unlock();
                }
            }
        });
    }

    public void testEndToEndPutRemovePassivation() throws Exception {
        this.doTestEndToEndPutRemove(true);
    }

    public void testEndToEndPutRemove() throws Exception {
        this.doTestEndToEndPutRemove(false);
    }

    private void doTestEndToEndPutRemove(boolean passivation) throws Exception {
        TestingUtil.withCacheManager(new OneEntryCacheManagerCallable(passivation){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void call() {
                this.cache.put((Object)"X", (Object)"1");
                this.cache.put((Object)"Y", (Object)"1");
                while (this.store.load("X") == null) {
                    TestingUtil.sleepThread(10L);
                }
                this.store.lock.lock();
                try {
                    this.cache.remove((Object)"X");
                    assert (null == this.cache.get((Object)"X")) : "cache must return X == null";
                }
                finally {
                    this.store.lock.unlock();
                }
            }
        });
    }

    private static abstract class OneEntryCacheManagerCallable
    extends CacheManagerCallable {
        protected final Cache<String, String> cache;
        protected final LockableCacheStore store;

        private static ConfigurationBuilder config(boolean passivation) {
            ConfigurationBuilder config = new ConfigurationBuilder();
            config.eviction().maxEntries(1).loaders().passivation(passivation).addStore().cacheStore((CacheStore)new LockableCacheStore()).async().enable();
            return config;
        }

        OneEntryCacheManagerCallable(boolean passivation) {
            super(TestCacheManagerFactory.createCacheManager(OneEntryCacheManagerCallable.config(passivation)));
            this.cache = this.cm.getCache();
            this.store = (LockableCacheStore)((Object)STORE.get());
        }
    }

    @CacheLoaderMetadata(configurationClass=LockableCacheStoreConfig.class)
    public static class LockableCacheStore
    extends DummyInMemoryCacheStore {
        private final ReentrantLock lock = new ReentrantLock();

        public LockableCacheStore() {
            STORE.set(this);
        }

        @Override
        public Class<? extends CacheLoaderConfig> getConfigurationClass() {
            return LockableCacheStoreConfig.class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void store(InternalCacheEntry ed) {
            this.lock.lock();
            try {
                super.store(ed);
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object key) {
            this.lock.lock();
            try {
                boolean bl = super.remove(key);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public static class LockableCacheStoreConfig
    extends DummyInMemoryCacheStore.Cfg {
        private static final long serialVersionUID = 1L;

        public LockableCacheStoreConfig() {
            this.setCacheLoaderClassName(LockableCacheStore.class.getName());
        }
    }

    static class MockAsyncStore
    extends AsyncStore {
        volatile boolean block = true;
        final CountDownLatch v1Latch;
        final CountDownLatch v2Latch;
        final CountDownLatch endLatch;
        final Object key;

        MockAsyncStore(Object key, CountDownLatch v1Latch, CountDownLatch v2Latch, CountDownLatch endLatch, CacheStore delegate, AsyncStoreConfig asyncStoreConfig) {
            super(delegate, asyncStoreConfig);
            this.v1Latch = v1Latch;
            this.v2Latch = v2Latch;
            this.endLatch = endLatch;
            this.key = key;
        }

        protected void applyModificationsSync(List<Modification> mods) throws CacheLoaderException {
            boolean keyFound;
            boolean bl = keyFound = this.findModificationForKey(this.key, mods) != null;
            if (keyFound && this.block) {
                log.trace((Object)"Wait for v1 latch");
                try {
                    this.v2Latch.countDown();
                    this.block = false;
                    this.v1Latch.await(2L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                super.applyModificationsSync(mods);
            } else if (keyFound && !this.block) {
                log.trace((Object)"Do v2 modification and unleash v1 latch");
                super.applyModificationsSync(mods);
                this.v1Latch.countDown();
                this.endLatch.countDown();
            }
        }

        private Modification findModificationForKey(Object key, List<Modification> mods) {
            block4: for (Modification modification : mods) {
                switch (modification.getType()) {
                    case STORE: {
                        Store store = (Store)modification;
                        if (!store.getStoredEntry().getKey().equals(key)) continue block4;
                        return store;
                    }
                    case REMOVE: {
                        Remove remove = (Remove)modification;
                        if (!remove.getKey().equals(key)) continue block4;
                        return remove;
                    }
                }
                return null;
            }
            return null;
        }
    }
}

