/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.distribution.MagicKey;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.testng.annotations.Test;

@Test(testName="lock.APIDistTest", groups={"functional"})
@CleanupAfterMethod
public class APIDistTest
extends MultipleCacheManagersTest {
    EmbeddedCacheManager cm1;
    EmbeddedCacheManager cm2;
    MagicKey key;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration cfg = this.createConfig();
        this.cm1 = TestCacheManagerFactory.createClusteredCacheManager(cfg);
        this.cm2 = TestCacheManagerFactory.createClusteredCacheManager(cfg);
        this.registerCacheManager(new CacheContainer[]{this.cm1, this.cm2});
        this.cm1.getCache();
        this.waitForClusterToForm();
        this.key = new MagicKey("Key mapped to Cache2", this.cm2.getCache());
    }

    protected Configuration createConfig() {
        Configuration cfg = APIDistTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, true);
        cfg.fluent().transaction().lockingMode(LockingMode.PESSIMISTIC);
        cfg.setL1CacheEnabled(false);
        cfg.setLockAcquisitionTimeout(100L);
        cfg.setNumOwners(1);
        cfg.setSyncCommitPhase(true);
        cfg.setSyncRollbackPhase(true);
        return cfg;
    }

    public void testLockAndGet() throws SystemException, NotSupportedException {
        Cache cache1 = this.cache(0);
        Cache cache2 = this.cache(1);
        cache1.put((Object)this.key, (Object)"v");
        assert ("v".equals(cache1.get((Object)this.key))) : "Could not find key " + this.key + " on cache1";
        assert ("v".equals(cache2.get((Object)this.key))) : "Could not find key " + this.key + " on cache2";
        this.tm(0).begin();
        this.log.trace((Object)"About to lock");
        cache1.getAdvancedCache().lock((Object[])new MagicKey[]{this.key});
        this.log.trace((Object)"About to get");
        assert ("v".equals(cache1.get((Object)this.key))) : "Could not find key " + this.key + " on cache1";
        this.tm(0).rollback();
    }

    public void testLockAndGetAndPut() throws SystemException, NotSupportedException, RollbackException, HeuristicRollbackException, HeuristicMixedException {
        String val;
        Cache cache1 = this.cache(0);
        Cache cache2 = this.cache(1);
        cache1.put((Object)this.key, (Object)"v");
        assert ("v".equals(cache1.get((Object)this.key))) : "Could not find key " + this.key + " on cache1";
        assert ("v".equals(cache2.get((Object)this.key))) : "Could not find key " + this.key + " on cache2";
        this.tm(0).begin();
        cache1.getAdvancedCache().lock((Object[])new MagicKey[]{this.key});
        assert ("v".equals(cache1.get((Object)this.key))) : "Could not find key " + this.key + " on cache1";
        String old = (String)cache1.put((Object)this.key, (Object)"new_value");
        assert ("v".equals(old)) : "Expected v, was " + old;
        this.log.trace((Object)"Before commit!");
        this.tm(0).commit();
        assert ("new_value".equals(val = (String)cache1.get((Object)this.key))) : "Could not find key " + this.key + " on cache1: expected new_value, was " + val;
        assert ("new_value".equals(val = (String)cache2.get((Object)this.key))) : "Could not find key " + this.key + " on cache2: expected new_value, was " + val;
    }

    public void testLockAndPutRetval() throws SystemException, NotSupportedException, RollbackException, HeuristicRollbackException, HeuristicMixedException {
        String val;
        Cache cache1 = this.cache(0);
        Cache cache2 = this.cache(1);
        cache1.put((Object)this.key, (Object)"v");
        assert ("v".equals(cache1.get((Object)this.key))) : "Could not find key " + this.key + " on cache1";
        assert ("v".equals(cache2.get((Object)this.key))) : "Could not find key " + this.key + " on cache2";
        this.tm(0).begin();
        cache1.getAdvancedCache().lock((Object[])new MagicKey[]{this.key});
        String old = (String)cache1.put((Object)this.key, (Object)"new_value");
        assert ("v".equals(old)) : "Expected v, was " + old;
        this.tm(0).commit();
        assert ("new_value".equals(val = (String)cache1.get((Object)this.key))) : "Could not find key " + this.key + " on cache1: expected new_value, was " + val;
        assert ("new_value".equals(val = (String)cache2.get((Object)this.key))) : "Could not find key " + this.key + " on cache2: expected new_value, was " + val;
    }

    public void testLockAndRemoveRetval() throws SystemException, NotSupportedException, RollbackException, HeuristicRollbackException, HeuristicMixedException {
        String val;
        Cache cache1 = this.cache(0);
        Cache cache2 = this.cache(1);
        cache1.put((Object)this.key, (Object)"v");
        assert ("v".equals(cache1.get((Object)this.key))) : "Could not find key " + this.key + " on cache1";
        assert ("v".equals(cache2.get((Object)this.key))) : "Could not find key " + this.key + " on cache2";
        this.tm(0).begin();
        cache1.getAdvancedCache().lock((Object[])new MagicKey[]{this.key});
        String old = (String)cache1.remove((Object)this.key);
        assert ("v".equals(old)) : "Expected v, was " + old;
        this.tm(0).commit();
        assert (null == (val = (String)cache1.get((Object)this.key))) : "Could not find key " + this.key + " on cache1: expected null, was " + val;
        assert (null == (val = (String)cache2.get((Object)this.key))) : "Could not find key " + this.key + " on cache2: expected null, was " + val;
    }
}

