/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.interceptors.BatchingInterceptor;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.tm.DummyTransactionManager;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="manager.CacheManagerComponentRegistryTest")
public class CacheManagerComponentRegistryTest
extends AbstractInfinispanTest {
    EmbeddedCacheManager cm;

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCacheManagers(this.cm);
        this.cm = null;
    }

    public void testForceSharedComponents() {
        Configuration defaultCfg = new Configuration();
        defaultCfg.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        defaultCfg.setFetchInMemoryState(false);
        defaultCfg.fluent().transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        defaultCfg.setFetchInMemoryState(false);
        this.cm = TestCacheManagerFactory.createCacheManager(GlobalConfiguration.getClusteredDefault(), defaultCfg);
        Cache c = this.cm.getCache();
        Configuration overrides = TestCacheManagerFactory.getDefaultConfiguration(true);
        overrides.setTransactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        this.cm.defineConfiguration("transactional", overrides);
        Cache transactional = this.cm.getCache("transactional");
        assert (TestingUtil.extractComponent(c, TransactionManager.class) == null);
        assert (TestingUtil.extractComponent(transactional, TransactionManager.class) instanceof DummyTransactionManager);
        assert (TestingUtil.extractComponent(c, Transport.class) != null);
        assert (TestingUtil.extractComponent(transactional, Transport.class) != null);
        assert (TestingUtil.extractComponent(c, Transport.class) == TestingUtil.extractComponent(transactional, Transport.class));
    }

    public void testForceUnsharedComponents() {
        Configuration defaultCfg = new Configuration();
        defaultCfg.setFetchInMemoryState(false);
        defaultCfg.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        defaultCfg.setEvictionStrategy(EvictionStrategy.NONE);
        this.cm = TestCacheManagerFactory.createCacheManager(GlobalConfiguration.getClusteredDefault(), defaultCfg);
        Cache c = this.cm.getCache();
        Configuration overrides = new Configuration();
        overrides.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cm.defineConfiguration("transactional", overrides);
        Cache transactional = this.cm.getCache("transactional");
        assert (TestingUtil.extractComponent(c, EvictionManager.class) != null);
        assert (TestingUtil.extractComponent(transactional, EvictionManager.class) != null);
        assert (TestingUtil.extractComponent(c, EvictionManager.class) != TestingUtil.extractComponent(transactional, EvictionManager.class));
    }

    public void testOverridingComponents() {
        Configuration defaultCfg = new Configuration();
        this.cm = TestCacheManagerFactory.createCacheManager(GlobalConfiguration.getClusteredDefault(), defaultCfg);
        Cache c = this.cm.getCache();
        Configuration overrides = new Configuration();
        overrides.setInvocationBatchingEnabled(true);
        this.cm.defineConfiguration("overridden", overrides);
        Cache overridden = this.cm.getCache("overridden");
        assert (!TestingUtil.extractComponent(c, InterceptorChain.class).containsInterceptorType(BatchingInterceptor.class));
        assert (TestingUtil.extractComponent(overridden, InterceptorChain.class).containsInterceptorType(BatchingInterceptor.class));
    }
}

