/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.manager.CacheContainer;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.CacheNotifierTxTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.cachelistener.CacheNotifierTest")
public class CacheNotifierTest
extends AbstractInfinispanTest {
    private Cache<Object, Object> cache;
    private CacheNotifier mockNotifier;
    private CacheNotifier origNotifier;
    private CacheContainer cm;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        Configuration c = new Configuration();
        c.fluent().transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        c.setCacheMode(Configuration.CacheMode.LOCAL);
        c.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cm = TestCacheManagerFactory.createCacheManager(c);
        this.cache = this.cm.getCache();
        this.mockNotifier = (CacheNotifier)Mockito.mock(CacheNotifier.class);
        this.origNotifier = TestingUtil.replaceComponent(this.cache, CacheNotifier.class, this.mockNotifier, true);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.replaceComponent(this.cache, CacheNotifier.class, this.origNotifier, true);
        TestingUtil.killCaches(this.cache);
        this.cm.stop();
    }

    @AfterClass(alwaysRun=true)
    public void destroyManager() {
        TestingUtil.killCacheManagers(this.cache.getCacheManager());
    }

    public void testVisit() throws Exception {
        this.initCacheData(Collections.singletonMap("key", "value"));
        this.cache.get((Object)"key");
        ((CacheNotifier)Mockito.verify((Object)this.mockNotifier)).notifyCacheEntryVisited(Matchers.eq((Object)"key"), Matchers.eq((Object)"value"), Matchers.eq((boolean)true), (InvocationContext)Matchers.isA(InvocationContext.class));
        ((CacheNotifier)Mockito.verify((Object)this.mockNotifier)).notifyCacheEntryVisited(Matchers.eq((Object)"key"), Matchers.eq((Object)"value"), Matchers.eq((boolean)false), (InvocationContext)Matchers.isA(InvocationContext.class));
    }

    public void testRemoveData() throws Exception {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("key", "value");
        data.put("key2", "value2");
        this.initCacheData(data);
        this.cache.remove((Object)"key2");
        ((CacheNotifier)Mockito.verify((Object)this.mockNotifier)).notifyCacheEntryRemoved(Matchers.eq((Object)"key2"), Matchers.eq((Object)"value2"), Matchers.eq((boolean)true), (InvocationContext)Matchers.isA(InvocationContext.class));
        ((CacheNotifier)Mockito.verify((Object)this.mockNotifier)).notifyCacheEntryRemoved(Matchers.eq((Object)"key2"), Matchers.isNull(), Matchers.eq((boolean)false), (InvocationContext)Matchers.isA(InvocationContext.class));
    }

    public void testPutMap() throws Exception {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("key", "value");
        data.put("key2", "value2");
        this.cache.putAll(data);
        this.expectSingleEntryCreated("key", "value");
        this.expectSingleEntryCreated("key2", "value2");
    }

    public void testOnlyModification() throws Exception {
        this.initCacheData(Collections.singletonMap("key", "value"));
        this.cache.put((Object)"key", (Object)"value2");
        ((CacheNotifier)Mockito.verify((Object)this.mockNotifier)).notifyCacheEntryModified(Matchers.eq((Object)"key"), Matchers.eq((Object)"value"), Matchers.eq((boolean)true), (InvocationContext)Matchers.isA(InvocationContext.class));
        ((CacheNotifier)Mockito.verify((Object)this.mockNotifier)).notifyCacheEntryModified(Matchers.eq((Object)"key"), Matchers.eq((Object)"value2"), Matchers.eq((boolean)false), (InvocationContext)Matchers.isA(InvocationContext.class));
    }

    public void testReplaceNotification() throws Exception {
        this.initCacheData(Collections.singletonMap("key", "value"));
        this.cache.replace((Object)"key", (Object)"value", (Object)"value2");
        ((CacheNotifier)Mockito.verify((Object)this.mockNotifier)).notifyCacheEntryModified(Matchers.eq((Object)"key"), Matchers.eq((Object)"value"), Matchers.eq((boolean)true), (InvocationContext)Matchers.isA(InvocationContext.class));
        ((CacheNotifier)Mockito.verify((Object)this.mockNotifier)).notifyCacheEntryModified(Matchers.eq((Object)"key"), Matchers.eq((Object)"value2"), Matchers.eq((boolean)false), (InvocationContext)Matchers.isA(InvocationContext.class));
    }

    public void testReplaceNoNotificationOnNoChange() throws Exception {
        this.initCacheData(Collections.singletonMap("key", "value"));
        this.cache.replace((Object)"key", (Object)"value2", (Object)"value3");
        ((CacheNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.never())).notifyCacheEntryModified(Matchers.eq((Object)"key"), Matchers.eq((Object)"value2"), Matchers.eq((boolean)true), (InvocationContext)Matchers.any(InvocationContext.class));
        ((CacheNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.never())).notifyCacheEntryModified(Matchers.eq((Object)"key"), Matchers.eq((Object)"value3"), Matchers.eq((boolean)false), (InvocationContext)Matchers.any(InvocationContext.class));
    }

    public void testNonexistentVisit() throws Exception {
        this.cache.get((Object)"doesNotExist");
    }

    public void testNonexistentRemove() throws Exception {
        this.cache.remove((Object)"doesNotExist");
    }

    public void testCreation() throws Exception {
        this.cache.put((Object)"key", (Object)"value");
        this.expectSingleEntryCreated("key", "value");
    }

    private void initCacheData(Map<String, String> data) {
        this.cache.putAll(data);
        ((CacheNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.atLeastOnce())).notifyCacheEntryCreated(Matchers.anyObject(), Matchers.anyBoolean(), (InvocationContext)Matchers.isA(InvocationContext.class));
        ((CacheNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.atLeastOnce())).notifyCacheEntryModified(Matchers.anyObject(), Matchers.anyObject(), Matchers.anyBoolean(), (InvocationContext)Matchers.isA(InvocationContext.class));
    }

    private void expectSingleEntryCreated(Object key, Object value) {
        CacheNotifierTxTest.expectSingleEntryCreated(key, value, this.mockNotifier);
    }
}

