/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachemanagerlistener;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="notifications.cachemanagerlistener.CacheManagerNotifierTest")
public class CacheManagerNotifierTest
extends AbstractInfinispanTest {
    EmbeddedCacheManager cm1;
    EmbeddedCacheManager cm2;

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCacheManagers(this.cm1, this.cm2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMockViewChange() {
        this.cm1 = TestCacheManagerFactory.createClusteredCacheManager();
        this.cm2 = TestCacheManagerFactory.createClusteredCacheManager();
        Configuration c = new Configuration();
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c.setFetchInMemoryState(false);
        this.cm1.defineConfiguration("cache", c);
        this.cm2.defineConfiguration("cache", c);
        this.cm1.getCache("cache");
        assert (this.cm1.getMembers().size() == 1);
        Address myAddress = this.cm1.getAddress();
        assert (this.cm1.getMembers().contains(myAddress));
        CacheManagerNotifierWrapper nw = new CacheManagerNotifierWrapper(TestingUtil.extractComponent(this.cm1.getCache("cache"), CacheManagerNotifier.class));
        CacheManagerNotifier origNotifier = TestingUtil.replaceComponent((CacheContainer)this.cm1, CacheManagerNotifier.class, nw, true);
        try {
            Cache c2 = this.cm2.getCache("cache");
            TestingUtil.blockUntilViewsReceived(60000L, new CacheContainer[]{this.cm1, this.cm2});
            assert (nw.notifyView);
            Assert.assertEquals((Object)myAddress, (Object)nw.address);
        }
        finally {
            TestingUtil.replaceComponent((CacheContainer)this.cm1, CacheManagerNotifier.class, origNotifier, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testViewChange() throws Exception {
        EmbeddedCacheManager cmA = TestCacheManagerFactory.createClusteredCacheManager();
        cmA.getCache();
        CountDownLatch barrier = new CountDownLatch(1);
        GetCacheManagerCheckListener listener = new GetCacheManagerCheckListener(barrier);
        cmA.addListener((Object)listener);
        EmbeddedCacheManager cmB = TestCacheManagerFactory.createClusteredCacheManager();
        cmB.getCache();
        try {
            barrier.await();
            assert (listener.cacheContainer != null);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(new CacheContainer[]{cmA, cmB});
            throw throwable;
        }
        TestingUtil.killCacheManagers(new CacheContainer[]{cmA, cmB});
    }

    @Listener
    public static class GetCacheManagerCheckListener {
        CacheContainer cacheContainer;
        CountDownLatch barrier;

        public GetCacheManagerCheckListener(CountDownLatch barrier) {
            this.barrier = barrier;
        }

        @ViewChanged
        public void onViewChange(ViewChangedEvent e) throws Exception {
            this.cacheContainer = e.getCacheManager();
            this.barrier.countDown();
        }
    }

    public static class CacheManagerNotifierWrapper
    implements CacheManagerNotifier {
        final CacheManagerNotifier realOne;
        volatile boolean notifyView;
        volatile Address address;

        public CacheManagerNotifierWrapper(CacheManagerNotifier realOne) {
            this.realOne = realOne;
        }

        public void notifyViewChange(List<Address> members, List<Address> oldMembers, Address myAddress, int viewId) {
            this.realOne.notifyViewChange(members, oldMembers, myAddress, viewId);
            this.notifyView = true;
            this.address = myAddress;
        }

        public void notifyCacheStarted(String cacheName) {
            this.realOne.notifyCacheStarted(cacheName);
        }

        public void notifyCacheStopped(String cacheName) {
            this.realOne.notifyCacheStopped(cacheName);
        }

        public void notifyMerge(List<Address> members, List<Address> oldMembers, Address myAddress, int viewId, List<List<Address>> subgroupsMerged) {
            this.realOne.notifyMerge(members, oldMembers, myAddress, viewId, subgroupsMerged);
        }

        public void addListener(Object listener) {
            this.realOne.addListener(listener);
        }

        public void removeListener(Object listener) {
            this.realOne.removeListener(listener);
        }

        public Set<Object> getListeners() {
            return this.realOne.getListeners();
        }
    }
}

