/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.container.DataContainer;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"})
@CleanupAfterMethod
public abstract class BaseDistStateTransferConsistencyTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(BaseDistStateTransferConsistencyTest.class);
    private final boolean isOptimistic;

    protected BaseDistStateTransferConsistencyTest(boolean isOptimistic) {
        this.isOptimistic = isOptimistic;
    }

    @Override
    protected void createCacheManagers() {
        ConfigurationBuilder builder = BaseDistStateTransferConsistencyTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true, true);
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).syncCommitPhase(true).syncRollbackPhase(true);
        if (this.isOptimistic) {
            builder.transaction().lockingMode(LockingMode.OPTIMISTIC).locking().writeSkewCheck(true).isolationLevel(IsolationLevel.REPEATABLE_READ).versioning().enable().scheme(VersioningScheme.SIMPLE);
        } else {
            builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        }
        builder.clustering().hash().numSegments(10).numOwners(2).l1().disable().onRehash(false).locking().lockAcquisitionTimeout(1000L);
        builder.clustering().stateTransfer().fetchInMemoryState(true).awaitInitialTransfer(false);
        this.createCluster(builder, 3);
        this.waitForClusterToForm();
    }

    public void testRemove() throws Exception {
        this.testStateTransferConsistency(Operation.REMOVE);
    }

    public void testClear() throws Exception {
        this.testStateTransferConsistency(Operation.CLEAR);
    }

    public void testPut() throws Exception {
        this.testStateTransferConsistency(Operation.PUT);
    }

    public void testPutMap() throws Exception {
        this.testStateTransferConsistency(Operation.PUT_MAP);
    }

    public void testPutIfAbsent() throws Exception {
        this.testStateTransferConsistency(Operation.PUT_IF_ABSENT);
    }

    public void testReplace() throws Exception {
        this.testStateTransferConsistency(Operation.REPLACE);
    }

    private void testStateTransferConsistency(Operation op) throws Exception {
        int owners;
        int i;
        int i2;
        int i3;
        int numKeys = 5;
        log.infof("Putting %d keys into cache ..", (Object)5);
        for (i3 = 0; i3 < 5; ++i3) {
            this.cache(0).put((Object)i3, (Object)("before_st_" + i3));
        }
        log.info((Object)"Finished putting keys");
        for (i3 = 0; i3 < 5; ++i3) {
            Assert.assertEquals((Object)("before_st_" + i3), (Object)this.cache(0).get((Object)i3));
            Assert.assertEquals((Object)("before_st_" + i3), (Object)this.cache(1).get((Object)i3));
            Assert.assertEquals((Object)("before_st_" + i3), (Object)this.cache(2).get((Object)i3));
        }
        final CountDownLatch applyStateProceedLatch = new CountDownLatch(1);
        final CountDownLatch applyStateStartedLatch1 = new CountDownLatch(1);
        this.advancedCache(0).addInterceptor(new CommandInterceptor(){

            protected Object handleDefault(InvocationContext ctx, VisitableCommand cmd) throws Throwable {
                if (cmd instanceof PutKeyValueCommand && ((PutKeyValueCommand)cmd).hasFlag(Flag.PUT_FOR_STATE_TRANSFER)) {
                    applyStateStartedLatch1.countDown();
                    if (!applyStateProceedLatch.await(15L, TimeUnit.SECONDS)) {
                        throw new TimeoutException();
                    }
                }
                return super.handleDefault(ctx, cmd);
            }
        }, 0);
        final CountDownLatch applyStateStartedLatch2 = new CountDownLatch(1);
        this.advancedCache(2).addInterceptor(new CommandInterceptor(){

            protected Object handleDefault(InvocationContext ctx, VisitableCommand cmd) throws Throwable {
                if (cmd instanceof PutKeyValueCommand && ((PutKeyValueCommand)cmd).hasFlag(Flag.PUT_FOR_STATE_TRANSFER)) {
                    applyStateStartedLatch2.countDown();
                    if (!applyStateProceedLatch.await(15L, TimeUnit.SECONDS)) {
                        throw new TimeoutException();
                    }
                }
                return super.handleDefault(ctx, cmd);
            }
        }, 0);
        log.info((Object)"Killing node 1 ..");
        TestingUtil.killCacheManagers(this.manager(1));
        log.info((Object)"Node 1 killed");
        DataContainer dc0 = this.advancedCache(0).getDataContainer();
        DataContainer dc2 = this.advancedCache(2).getDataContainer();
        if (!applyStateStartedLatch1.await(15L, TimeUnit.SECONDS)) {
            throw new TimeoutException();
        }
        if (!applyStateStartedLatch2.await(15L, TimeUnit.SECONDS)) {
            throw new TimeoutException();
        }
        if (op == Operation.CLEAR) {
            log.info((Object)"Clearing cache ..");
            this.cache(0).clear();
            log.info((Object)"Finished clearing cache");
            Assert.assertEquals((long)0L, (long)dc0.size());
            Assert.assertEquals((long)0L, (long)dc2.size());
        } else if (op == Operation.REMOVE) {
            log.info((Object)"Removing all keys one by one ..");
            for (i2 = 0; i2 < 5; ++i2) {
                this.cache(0).remove((Object)i2);
            }
            log.info((Object)"Finished removing keys");
            Assert.assertEquals((long)0L, (long)dc0.size());
            Assert.assertEquals((long)0L, (long)dc2.size());
        } else if (op == Operation.PUT || op == Operation.PUT_MAP || op == Operation.REPLACE || op == Operation.PUT_IF_ABSENT) {
            log.info((Object)"Updating all keys ..");
            if (op == Operation.PUT) {
                for (int i4 = 0; i4 < 5; ++i4) {
                    this.cache(0).put((Object)i4, (Object)("after_st_" + i4));
                }
            } else if (op == Operation.PUT_MAP) {
                HashMap<Integer, String> toPut = new HashMap<Integer, String>();
                for (i = 0; i < 5; ++i) {
                    toPut.put(i, "after_st_" + i);
                }
                this.cache(0).putAll(toPut);
            } else if (op == Operation.REPLACE) {
                for (int i5 = 0; i5 < 5; ++i5) {
                    String expectedOldValue = "before_st_" + i5;
                    boolean replaced = this.cache(0).replace((Object)i5, (Object)expectedOldValue, (Object)("after_st_" + i5));
                    Assert.assertTrue((boolean)replaced);
                }
            } else {
                for (int i6 = 0; i6 < 5; ++i6) {
                    String expectedOldValue = "before_st_" + i6;
                    Object prevValue = this.cache(0).putIfAbsent((Object)i6, (Object)("after_st_" + i6));
                    Assert.assertEquals((Object)expectedOldValue, (Object)prevValue);
                }
            }
            log.info((Object)"Finished updating keys");
        }
        applyStateProceedLatch.countDown();
        TestingUtil.waitForRehashToComplete(this.cache(0), this.cache(2));
        log.infof("Data container of NodeA has %d keys: %s", (Object)dc0.size(), (Object)dc0.entrySet());
        log.infof("Data container of NodeC has %d keys: %s", (Object)dc2.size(), (Object)dc2.entrySet());
        if (op == Operation.CLEAR || op == Operation.REMOVE) {
            for (i2 = 0; i2 < 5; ++i2) {
                Assert.assertNull((Object)dc0.get((Object)i2));
                Assert.assertNull((Object)dc2.get((Object)i2));
            }
        } else if (op == Operation.PUT || op == Operation.PUT_MAP || op == Operation.REPLACE) {
            ConsistentHash ch = this.advancedCache(0).getComponentRegistry().getStateTransferManager().getCacheTopology().getReadConsistentHash();
            for (i = 0; i < 5; ++i) {
                owners = 0;
                if (dc0.get((Object)i) != null) {
                    ++owners;
                }
                if (dc2.get((Object)i) != null) {
                    ++owners;
                }
                Assert.assertEquals((String)"Wrong number of owners", (long)ch.locateOwners((Object)i).size(), (long)owners);
                String expected = "after_st_" + i;
                Assert.assertEquals((Object)expected, (Object)this.cache(0).get((Object)i));
                Assert.assertEquals((Object)("after_st_" + i), (Object)this.cache(2).get((Object)i));
            }
        } else {
            ConsistentHash ch = this.advancedCache(0).getComponentRegistry().getStateTransferManager().getCacheTopology().getReadConsistentHash();
            for (i = 0; i < 5; ++i) {
                owners = 0;
                if (dc0.get((Object)i) != null) {
                    ++owners;
                }
                if (dc2.get((Object)i) != null) {
                    ++owners;
                }
                Assert.assertEquals((String)"Wrong number of owners", (long)ch.locateOwners((Object)i).size(), (long)owners);
                String expected = "before_st_" + i;
                Assert.assertEquals((Object)expected, (Object)this.cache(0).get((Object)i));
                Assert.assertEquals((Object)expected, (Object)this.cache(2).get((Object)i));
            }
        }
    }

    private static enum Operation {
        REMOVE,
        CLEAR,
        PUT,
        PUT_MAP,
        PUT_IF_ABSENT,
        REPLACE;

    }
}

