/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.DataRehashed;
import org.infinispan.notifications.cachelistener.event.DataRehashedEvent;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.DataRehashedEventTest")
@CleanupAfterMethod
public class DataRehashedEventTest
extends MultipleCacheManagersTest {
    private ConfigurationBuilder defaultConfig = DataRehashedEventTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
    private DataRehashedListener rehashListener;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createClusteredCaches(1, this.defaultConfig);
        Cache c1 = this.cache(0);
        this.rehashListener = new DataRehashedListener();
        c1.addListener((Object)this.rehashListener);
    }

    public void testJoinAndLeave() {
        ConsistentHash ch1Node = this.advancedCache(0).getDistributionManager().getReadConsistentHash();
        Assert.assertEquals((int)this.rehashListener.removeEvents().size(), (int)0);
        this.addClusterEnabledCacheManager(this.defaultConfig);
        this.cache(1);
        TestingUtil.waitForRehashToComplete(this.cache(0), this.cache(1));
        ConsistentHash ch2Nodes = this.advancedCache(0).getDistributionManager().getReadConsistentHash();
        List<DataRehashedEvent<Object, Object>> events = this.rehashListener.removeEvents();
        Assert.assertEquals((int)events.size(), (int)2);
        DataRehashedEvent<Object, Object> pre = events.get(0);
        DataRehashedEvent<Object, Object> post = events.get(1);
        Assert.assertTrue((boolean)pre.isPre());
        Assert.assertEquals((Object)pre.getConsistentHashAtStart(), (Object)ch1Node);
        Assert.assertNotNull((Object)pre.getConsistentHashAtEnd());
        Assert.assertEquals((Collection)pre.getMembersAtEnd(), (Collection)ch2Nodes.getMembers());
        Assert.assertFalse((boolean)post.isPre());
        Assert.assertEquals((Object)post.getConsistentHashAtStart(), (Object)ch1Node);
        Assert.assertEquals((Object)post.getConsistentHashAtEnd(), (Object)ch2Nodes);
        this.addClusterEnabledCacheManager(this.defaultConfig);
        this.cache(2);
        TestingUtil.waitForRehashToComplete(this.cache(0), this.cache(1), this.cache(2));
        ConsistentHash ch3Nodes = this.advancedCache(0).getDistributionManager().getReadConsistentHash();
        events = this.rehashListener.removeEvents();
        Assert.assertEquals((int)events.size(), (int)2);
        pre = events.get(0);
        post = events.get(1);
        Assert.assertTrue((boolean)pre.isPre());
        Assert.assertEquals((Object)pre.getConsistentHashAtStart(), (Object)ch2Nodes);
        Assert.assertNotNull((Object)pre.getConsistentHashAtEnd());
        Assert.assertEquals((Collection)pre.getMembersAtEnd(), (Collection)ch3Nodes.getMembers());
        Assert.assertFalse((boolean)post.isPre());
        Assert.assertEquals((Object)post.getConsistentHashAtStart(), (Object)ch2Nodes);
        Assert.assertEquals((Object)post.getConsistentHashAtEnd(), (Object)ch3Nodes);
        this.killMember(2);
        ConsistentHash chAfterLeave = this.advancedCache(0).getDistributionManager().getReadConsistentHash();
        events = this.rehashListener.removeEvents();
        Assert.assertEquals((int)events.size(), (int)2);
        pre = events.get(0);
        post = events.get(1);
        Assert.assertTrue((boolean)pre.isPre());
        Assert.assertNotNull((Object)pre.getConsistentHashAtStart());
        Assert.assertEquals((Collection)pre.getMembersAtStart(), (Collection)chAfterLeave.getMembers());
        Assert.assertEquals((Object)pre.getConsistentHashAtEnd(), (Object)chAfterLeave);
        Assert.assertFalse((boolean)post.isPre());
        Assert.assertEquals((Object)post.getConsistentHashAtStart(), (Object)pre.getConsistentHashAtStart());
        Assert.assertEquals((Object)post.getConsistentHashAtEnd(), (Object)pre.getConsistentHashAtEnd());
        this.killMember(1);
        events = this.rehashListener.removeEvents();
        Assert.assertEquals((int)events.size(), (int)0);
    }

    @Listener
    public class DataRehashedListener {
        private volatile List<DataRehashedEvent<Object, Object>> events = new CopyOnWriteArrayList<DataRehashedEvent<Object, Object>>();

        @DataRehashed
        public void onDataRehashed(DataRehashedEvent<Object, Object> e) {
            DataRehashedEventTest.this.log.tracef("New event received: %s", e);
            this.events.add(e);
        }

        List<DataRehashedEvent<Object, Object>> removeEvents() {
            List<DataRehashedEvent<Object, Object>> oldEvents = this.events;
            this.events = new CopyOnWriteArrayList<DataRehashedEvent<Object, Object>>();
            return oldEvents;
        }
    }
}

