/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.io.File;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.FileCacheStoreConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.statetransfer.StateTransferFunctionalTest;
import org.infinispan.statetransfer.StateTransferTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.StateTransferFileCacheLoaderFunctionalTest")
public class StateTransferFileCacheLoaderFunctionalTest
extends MultipleCacheManagersTest {
    static final Log log = LogFactory.getLog(StateTransferFileCacheLoaderFunctionalTest.class);
    static String cacheName = "nbst-with-file-loader";
    volatile int testCount = 0;
    ThreadLocal<Boolean> sharedCacheLoader = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    String tmpDirectory1;
    String tmpDirectory2;
    String tmpDirectory3;
    String tmpDirectory4;
    ConfigurationBuilder configurationBuilder;

    @BeforeTest
    protected void setUpTempDir() {
        String basedir = TestingUtil.tmpDirectory(this);
        this.tmpDirectory1 = basedir + "1";
        this.tmpDirectory2 = basedir + "2";
        this.tmpDirectory3 = basedir + "3";
        this.tmpDirectory4 = basedir + "4";
    }

    @AfterMethod(alwaysRun=true)
    protected void clearTempDir() {
        TestingUtil.recursiveFileRemove(this.tmpDirectory1);
        new File(this.tmpDirectory1).mkdirs();
        TestingUtil.recursiveFileRemove(this.tmpDirectory2);
        new File(this.tmpDirectory2).mkdirs();
        TestingUtil.recursiveFileRemove(this.tmpDirectory3);
        new File(this.tmpDirectory3).mkdirs();
        TestingUtil.recursiveFileRemove(this.tmpDirectory4);
        new File(this.tmpDirectory4).mkdirs();
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.configurationBuilder = StateTransferFileCacheLoaderFunctionalTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        this.configurationBuilder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.configurationBuilder.clustering().sync().replTimeout(30000L);
        this.configurationBuilder.clustering().stateTransfer().fetchInMemoryState(true);
        this.configurationBuilder.locking().useLockStriping(false);
    }

    protected EmbeddedCacheManager createCacheManager(String tmpDirectory) {
        this.configurationBuilder.loaders().clearCacheLoaders();
        this.configurationBuilder.loaders().shared(this.sharedCacheLoader.get().booleanValue());
        FileCacheStoreConfigurationBuilder fcsBuilder = this.configurationBuilder.loaders().addFileCacheStore();
        ((FileCacheStoreConfigurationBuilder)((FileCacheStoreConfigurationBuilder)((FileCacheStoreConfigurationBuilder)fcsBuilder.purgeSynchronously(true)).fetchPersistentState(true)).purgeOnStartup(false)).location(tmpDirectory);
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager();
        cm.defineConfiguration(cacheName, this.configurationBuilder.build());
        return cm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSharedLoader() throws Exception {
        EmbeddedCacheManager cm1 = null;
        EmbeddedCacheManager cm2 = null;
        try {
            this.sharedCacheLoader.set(true);
            cm1 = this.createCacheManager(this.tmpDirectory1);
            Cache c1 = cm1.getCache(cacheName);
            StateTransferTestingUtil.verifyNoDataOnLoader((Cache<Object, Object>)c1);
            StateTransferTestingUtil.verifyNoData((Cache<Object, Object>)c1);
            StateTransferTestingUtil.writeInitialData((Cache<Object, Object>)c1);
            cm2 = this.createCacheManager(this.tmpDirectory2);
            Cache c2 = cm2.getCache(cacheName);
            TestingUtil.blockUntilViewsReceived(60000L, c1, c2);
            StateTransferTestingUtil.verifyInitialDataOnLoader((Cache<Object, Object>)c1);
            StateTransferTestingUtil.verifyInitialData((Cache<Object, Object>)c1);
            StateTransferTestingUtil.verifyNoDataOnLoader((Cache<Object, Object>)c2);
            StateTransferTestingUtil.verifyNoData((Cache<Object, Object>)c2);
        }
        finally {
            if (cm1 != null) {
                cm1.stop();
            }
            if (cm2 != null) {
                cm2.stop();
            }
            this.sharedCacheLoader.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInitialStateTransfer() throws Exception {
        ++this.testCount;
        log.info((Object)("testInitialStateTransfer start - " + this.testCount));
        EmbeddedCacheManager cm1 = null;
        EmbeddedCacheManager cm2 = null;
        try {
            cm1 = this.createCacheManager(this.tmpDirectory1);
            Cache cache1 = cm1.getCache(cacheName);
            StateTransferTestingUtil.writeInitialData((Cache<Object, Object>)cache1);
            cm2 = this.createCacheManager(this.tmpDirectory2);
            Cache cache2 = cm2.getCache(cacheName);
            TestingUtil.blockUntilViewsReceived(60000L, cache1, cache2);
            StateTransferTestingUtil.verifyInitialData((Cache<Object, Object>)cache2);
            log.info((Object)("testInitialStateTransfer end - " + this.testCount));
        }
        finally {
            if (cm1 != null) {
                cm1.stop();
            }
            if (cm2 != null) {
                cm2.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInitialStateTransferInDifferentThread(Method m) throws Exception {
        ++this.testCount;
        log.info((Object)(m.getName() + " start - " + this.testCount));
        EmbeddedCacheManager cm1 = null;
        EmbeddedCacheManager cm2 = null;
        EmbeddedCacheManager cm30 = null;
        try {
            EmbeddedCacheManager cm3;
            Cache cache1 = null;
            Cache cache2 = null;
            Cache cache3 = null;
            cm1 = this.createCacheManager(this.tmpDirectory1);
            cache1 = cm1.getCache(cacheName);
            StateTransferTestingUtil.writeInitialData((Cache<Object, Object>)cache1);
            cm2 = this.createCacheManager(this.tmpDirectory2);
            cache2 = cm2.getCache(cacheName);
            cache1.put((Object)"delay", (Object)new StateTransferFunctionalTest.DelayTransfer());
            TestingUtil.blockUntilViewsReceived(60000L, cache1, cache2);
            StateTransferTestingUtil.verifyInitialData((Cache<Object, Object>)cache2);
            cm30 = cm3 = this.createCacheManager(this.tmpDirectory3);
            Future<Void> f1 = this.fork(new Callable<Void>((CacheContainer)cm3){
                final /* synthetic */ CacheContainer val$cm3;
                {
                    this.val$cm3 = cacheContainer;
                }

                @Override
                public Void call() throws Exception {
                    this.val$cm3.getCache(cacheName);
                    return null;
                }
            });
            f1.get();
            cache3 = cm3.getCache(cacheName);
            TestingUtil.blockUntilViewsReceived(120000L, cache1, cache2, cache3);
            StateTransferTestingUtil.verifyInitialData((Cache<Object, Object>)cache3);
            log.info((Object)("testConcurrentStateTransfer end - " + this.testCount));
        }
        finally {
            if (cm1 != null) {
                cm1.stop();
            }
            if (cm2 != null) {
                cm2.stop();
            }
            if (cm30 != null) {
                cm30.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentStateTransfer() throws Exception {
        ++this.testCount;
        log.info((Object)("testConcurrentStateTransfer start - " + this.testCount));
        EmbeddedCacheManager cm1 = null;
        EmbeddedCacheManager cm2 = null;
        EmbeddedCacheManager cm30 = null;
        EmbeddedCacheManager cm40 = null;
        try {
            Cache cache1 = null;
            Cache cache2 = null;
            Cache cache3 = null;
            Cache cache4 = null;
            cm1 = this.createCacheManager(this.tmpDirectory1);
            cache1 = cm1.getCache(cacheName);
            StateTransferTestingUtil.writeInitialData((Cache<Object, Object>)cache1);
            cm2 = this.createCacheManager(this.tmpDirectory2);
            cache2 = cm2.getCache(cacheName);
            cache1.put((Object)"delay", (Object)new StateTransferFunctionalTest.DelayTransfer());
            TestingUtil.blockUntilViewsReceived(60000L, cache1, cache2);
            StateTransferTestingUtil.verifyInitialData((Cache<Object, Object>)cache2);
            EmbeddedCacheManager cm3 = this.createCacheManager(this.tmpDirectory3);
            EmbeddedCacheManager cm4 = this.createCacheManager(this.tmpDirectory4);
            cm30 = cm3;
            cm40 = cm4;
            Future<Void> f1 = this.fork(new Callable<Void>((CacheContainer)cm3){
                final /* synthetic */ CacheContainer val$cm3;
                {
                    this.val$cm3 = cacheContainer;
                }

                @Override
                public Void call() throws Exception {
                    this.val$cm3.getCache(cacheName);
                    return null;
                }
            });
            Future<Void> f2 = this.fork(new Callable<Void>((CacheContainer)cm4){
                final /* synthetic */ CacheContainer val$cm4;
                {
                    this.val$cm4 = cacheContainer;
                }

                @Override
                public Void call() throws Exception {
                    this.val$cm4.getCache(cacheName);
                    return null;
                }
            });
            f1.get();
            f2.get();
            cache3 = cm3.getCache(cacheName);
            cache4 = cm4.getCache(cacheName);
            TestingUtil.blockUntilViewsReceived(120000L, cache1, cache2, cache3, cache4);
            StateTransferTestingUtil.verifyInitialData((Cache<Object, Object>)cache3);
            StateTransferTestingUtil.verifyInitialData((Cache<Object, Object>)cache4);
            log.info((Object)("testConcurrentStateTransfer end - " + this.testCount));
        }
        finally {
            if (cm1 != null) {
                cm1.stop();
            }
            if (cm2 != null) {
                cm2.stop();
            }
            if (cm30 != null) {
                cm30.stop();
            }
            if (cm40 != null) {
                cm40.stop();
            }
        }
    }
}

