/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.fwk;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CheckPoint {
    private static final Log log = LogFactory.getLog(CheckPoint.class);
    public static final int INFINITE = 999999999;
    private final Lock lock = new ReentrantLock();
    private final Condition unblockCondition = this.lock.newCondition();
    private final Map<String, EventStatus> events = new HashMap<String, EventStatus>();

    public void awaitStrict(String event, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        this.awaitStrict(event, 1, timeout, unit);
    }

    public boolean await(String event, long timeout, TimeUnit unit) throws InterruptedException {
        return this.await(event, 1, timeout, unit);
    }

    public void awaitStrict(String event, int count, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this.await(event, count, timeout, unit)) {
            throw new TimeoutException("Timed out waiting for event " + event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(String event, int count, long timeout, TimeUnit unit) throws InterruptedException {
        log.tracef("Waiting for event %s * %d", (Object)event, (Object)count);
        this.lock.lock();
        try {
            EventStatus status = null;
            long waitNanos = unit.toNanos(timeout);
            while (waitNanos > 0L) {
                status = this.events.get(event);
                if (status == null) {
                    status = new EventStatus();
                    this.events.put(event, status);
                }
                if (status.available >= count) {
                    status.available -= count;
                    break;
                }
                waitNanos = this.unblockCondition.awaitNanos(waitNanos);
            }
            if (waitNanos <= 0L) {
                log.errorf("Timed out waiting for event %s * %d (available = %d, total = %d", new Object[]{event, count, status.available, status.total});
                status.available = -1;
                boolean bl = false;
                return bl;
            }
            log.tracef("Received event %s * %d (available = %d, total = %d)", new Object[]{event, count, status.available, status.total});
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String peek(long timeout, TimeUnit unit, String ... expectedEvents) throws InterruptedException {
        log.tracef("Waiting for any one of event %s * %d", (Object)Arrays.toString(expectedEvents));
        String found = null;
        this.lock.lock();
        try {
            long waitNanos = unit.toNanos(timeout);
            while (waitNanos > 0L) {
                for (String event : expectedEvents) {
                    EventStatus status = this.events.get(event);
                    if (status == null || status.available < 1) continue;
                    found = event;
                    break;
                }
                if (found != null) break;
                waitNanos = this.unblockCondition.awaitNanos(waitNanos);
            }
            if (waitNanos <= 0L) {
                log.tracef("Timed out waiting for events %s", (Object)Arrays.toString(expectedEvents));
                String[] arr$ = null;
                return arr$;
            }
            EventStatus status = this.events.get(found);
            log.tracef("Received event %s (available = %d, total = %d)", found, (Object)status.available, (Object)status.total);
            String string = found;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void trigger(String event) {
        this.trigger(event, 1);
    }

    public void triggerForever(String event) {
        this.trigger(event, 999999999);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger(String event, int count) {
        this.lock.lock();
        try {
            EventStatus status = this.events.get(event);
            if (status == null) {
                status = new EventStatus();
                this.events.put(event, status);
            } else if (status.available < 0) {
                throw new IllegalStateException("Thread already timed out waiting for event " + event);
            }
            status.available = count != 999999999 ? status.available + count : 999999999;
            status.total = count != 999999999 ? status.total + count : 999999999;
            log.tracef("Triggering event %s * %d (available = %d, total = %d)", new Object[]{event, count, status.available, status.total});
            this.unblockCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "CheckPoint" + this.events;
    }

    private class EventStatus {
        int available;
        int total;

        private EventStatus() {
        }

        public String toString() {
            return "" + this.available + "/" + this.total;
        }
    }
}

