/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.fwk;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.DISCARD;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Promise;
import org.jgroups.util.Tuple;
import org.jgroups.util.UUID;

public class TEST_PING
extends Discovery {
    @Property(description="Test name. Default is empty String.")
    private String testName = "";
    private DISCARD discard;
    private volatile boolean stopped;
    private static ConcurrentMap<DiscoveryKey, ConcurrentMap<Address, TEST_PING>> all = new ConcurrentHashMap<DiscoveryKey, ConcurrentMap<Address, TEST_PING>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PingData> findMembers(Promise<JoinRsp> promise, int numExpectedRsps, boolean breakOnCoord, ViewId viewId) {
        if (!this.stopped) {
            Map<Address, TEST_PING> discoveries = this.registerInDiscoveries();
            boolean discardEnabled = this.isDiscardEnabled(this);
            if (!discardEnabled) {
                if (!discoveries.isEmpty()) {
                    LinkedList<PingData> rsps = new LinkedList<PingData>();
                    Map<Address, TEST_PING> map = discoveries;
                    synchronized (map) {
                        for (TEST_PING discovery : discoveries.values()) {
                            boolean traceEnabled = this.log.isTraceEnabled();
                            if (discovery != this) {
                                boolean remoteDiscardEnabled = this.isDiscardEnabled(discovery);
                                if (!remoteDiscardEnabled && !discovery.stopped) {
                                    this.addPingRsp(rsps, discovery);
                                    continue;
                                }
                                if (discovery.stopped) {
                                    this.log.debug(String.format("%s is stopped, so no ping responses will be received", discovery.getLocalAddr()));
                                    continue;
                                }
                                if (traceEnabled) {
                                    this.log.trace("Skipping sending response cos DISCARD is on");
                                }
                                this.addPingRsp(new LinkedList<PingData>(), discovery);
                                continue;
                            }
                            if (!traceEnabled) continue;
                            this.log.trace("Skipping sending discovery to self");
                        }
                    }
                    return rsps;
                }
                this.log.debug("No other nodes yet, so skip sending get-members request");
                return new LinkedList<PingData>();
            }
            this.log.debug("Not sending discovery because DISCARD is on");
            return new LinkedList<PingData>();
        }
        this.log.debug("Discovery protocol already stopped, so don't look for members");
        return new LinkedList<PingData>();
    }

    private boolean isDiscardEnabled(TEST_PING discovery) {
        List protocols = discovery.getProtocolStack().getProtocols();
        for (Protocol protocol : protocols) {
            if (!(protocol instanceof DISCARD)) continue;
            discovery.discard = (DISCARD)protocol;
        }
        return discovery.discard != null && discovery.discard.isDiscardAll();
    }

    private void addPingRsp(LinkedList<PingData> rsps, TEST_PING discovery) {
        this.mapAddrWithPhysicalAddr(this, discovery);
        this.mapAddrWithPhysicalAddr(discovery, this);
        Address localAddr = discovery.getLocalAddr();
        List<PhysicalAddress> physicalAddrs = Arrays.asList((PhysicalAddress)discovery.down(new Event(87, (Object)localAddr)));
        String logicalName = UUID.get((Address)localAddr);
        PingData pingRsp = new PingData(localAddr, discovery.getJGroupsView(), discovery.isServer(), logicalName, physicalAddrs);
        if (this.log.isTraceEnabled()) {
            this.log.trace(String.format("Returning ping rsp: %s", pingRsp));
        }
        rsps.add(pingRsp);
    }

    private void mapAddrWithPhysicalAddr(TEST_PING local, TEST_PING remote) {
        PhysicalAddress physical_addr = (PhysicalAddress)remote.down(new Event(87, (Object)remote.getLocalAddr()));
        local.down(new Event(89, (Object)new Tuple((Object)remote.getLocalAddr(), (Object)physical_addr)));
        if (this.log.isTraceEnabled()) {
            this.log.trace(String.format("Map %s with physical address %s in %s", new Object[]{remote.getLocalAddr(), physical_addr, local}));
        }
    }

    private Map<Address, TEST_PING> registerInDiscoveries() {
        TEST_PING prev;
        boolean traceEnabled;
        ConcurrentMap ret;
        DiscoveryKey key = new DiscoveryKey(this.testName, this.group_addr);
        ConcurrentHashMap<Address, TEST_PING> discoveries = (ConcurrentHashMap<Address, TEST_PING>)all.get(key);
        if (discoveries == null && (ret = (ConcurrentMap)all.putIfAbsent(key, discoveries = new ConcurrentHashMap<Address, TEST_PING>())) != null) {
            discoveries = ret;
        }
        if (traceEnabled = this.log.isTraceEnabled()) {
            this.log.trace(TEST_PING.sf("Discoveries for %s are : %s", key, discoveries));
        }
        if ((prev = discoveries.putIfAbsent(this.local_addr, this)) == null && traceEnabled) {
            this.log.trace(TEST_PING.sf("Add discovery for %s to cache.  The cache now contains: %s", this.local_addr, discoveries));
        }
        return discoveries;
    }

    public void stop() {
        this.log.debug(String.format("Stop discovery for %s", this.local_addr));
        super.stop();
        DiscoveryKey key = new DiscoveryKey(this.testName, this.group_addr);
        Map discoveries = (Map)all.get(key);
        if (discoveries != null) {
            this.removeDiscovery(key, discoveries);
        } else {
            this.log.debug(String.format("Test (%s) started but not registered discovery", key));
        }
        this.stopped = true;
    }

    private void removeDiscovery(DiscoveryKey key, Map<Address, TEST_PING> discoveries) {
        boolean removed;
        discoveries.remove(this.local_addr);
        if (discoveries.isEmpty() && !(removed = all.remove(key, discoveries)) && all.containsKey(key)) {
            throw new IllegalStateException(String.format("Concurrent discovery removal for test=%s but not removed??", this.testName));
        }
    }

    protected Address getLocalAddr() {
        return this.local_addr;
    }

    protected View getJGroupsView() {
        return this.view;
    }

    protected boolean isServer() {
        return this.is_server;
    }

    public Collection<PhysicalAddress> fetchClusterMembers(String cluster_name) {
        return null;
    }

    public boolean sendDiscoveryRequestsInParallel() {
        return false;
    }

    public boolean isDynamic() {
        return false;
    }

    public String toString() {
        return "TEST_PING@" + this.local_addr;
    }

    private static String sf(String format, Object ... args) {
        return String.format(format, args);
    }

    static {
        ClassConfigurator.addProtocol((short)1320, TEST_PING.class);
    }

    private static class DiscoveryKey {
        final String testName;
        final String clusterName;

        private DiscoveryKey(String testName, String clusterName) {
            this.clusterName = clusterName;
            this.testName = testName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiscoveryKey that = (DiscoveryKey)o;
            if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) {
                return false;
            }
            return !(this.testName != null ? !this.testName.equals(that.testName) : that.testName != null);
        }

        public int hashCode() {
            int result = this.testName != null ? this.testName.hashCode() : 0;
            result = 31 * result + (this.clusterName != null ? this.clusterName.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "DiscoveryKey{clusterName='" + this.clusterName + '\'' + ", testName='" + this.testName + '\'' + '}';
        }
    }
}

