/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.List;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.RemoteException;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.TimeoutException;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.StaleLockRecoveryTest")
public class StaleLockRecoveryTest
extends MultipleCacheManagersTest {
    Cache<String, String> c1;
    Cache<String, String> c2;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = StaleLockRecoveryTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC, true);
        c.fluent().transaction().lockingMode(LockingMode.PESSIMISTIC);
        c.setLockAcquisitionTimeout(500L);
        List caches = this.createClusteredCaches(2, "tx", c);
        this.c1 = caches.get(0);
        this.c2 = caches.get(1);
    }

    public void testStaleLock() throws SystemException, NotSupportedException {
        this.c1.put((Object)"k", (Object)"v");
        assert (((String)this.c1.get((Object)"k")).equals("v"));
        assert (((String)this.c2.get((Object)"k")).equals("v"));
        TransactionManager tm = TestingUtil.getTransactionManager(this.c1);
        tm.begin();
        this.c1.getAdvancedCache().lock((Object[])new String[]{"k"});
        tm.suspend();
        this.assertLocked(this.c1, "k");
        this.assertLocked(this.c2, "k");
        ((EmbeddedCacheManager)this.cacheManagers.get(0)).stop();
        TestingUtil.blockUntilViewReceived(this.c2, 1);
        EmbeddedCacheManager cacheManager = this.c2.getCacheManager();
        assert (cacheManager.getMembers().size() == 1);
        TestingUtil.sleepThread(1000L);
        this.assertNotLocked(this.c2, "k");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertLocked(Cache<String, String> c, String key) throws SystemException, NotSupportedException {
        TransactionManager tm = TestingUtil.getTransactionManager(c);
        tm.begin();
        try {
            c.put((Object)key, (Object)"dummy");
            assert (false) : "Should have been locked!";
        }
        catch (TimeoutException e) {
        }
        catch (RemoteException e) {
            assert (e.getCause() instanceof TimeoutException);
        }
        finally {
            tm.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertNotLocked(Cache<String, String> c, String key) throws SystemException, NotSupportedException {
        TransactionManager tm = TestingUtil.getTransactionManager(c);
        tm.begin();
        try {
            c.put((Object)key, (Object)"dummy");
        }
        catch (TimeoutException e) {
            assert (false) : "Should not have been locked!";
        }
        finally {
            tm.rollback();
        }
    }
}

