/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.BackupForConfigTest")
public class BackupForConfigTest
extends SingleCacheManagerTest {
    ConfigurationBuilder nycBackup;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder lonGc = GlobalConfigurationBuilder.defaultClusteredBuilder();
        lonGc.site().localSite("LON");
        ConfigurationBuilder lon = BackupForConfigTest.getDefaultClusteredCacheConfig(CacheMode.LOCAL, false);
        lon.sites().addBackup().site("NYC").strategy(BackupConfiguration.BackupStrategy.SYNC);
        this.nycBackup = BackupForConfigTest.getDefaultClusteredCacheConfig(CacheMode.LOCAL, false);
        this.nycBackup.sites().backupFor().remoteSite("NYC").defaultRemoteCache();
        return TestCacheManagerFactory.createCacheManager(lonGc, lon);
    }

    public void testBackupForIsCorrect() {
        this.cacheManager.getCache();
        this.cacheManager.defineConfiguration("nycBackup", this.nycBackup.build());
        this.cacheManager.getCache("nycBackup");
        SitesConfiguration sitesConfig = this.cache("nycBackup").getCacheConfiguration().sites();
        AssertJUnit.assertEquals((String)"___defaultcache", (String)sitesConfig.backupFor().remoteCache());
        AssertJUnit.assertEquals((String)"NYC", (String)sitesConfig.backupFor().remoteSite());
        sitesConfig.backupFor().isBackupFor("NYC", "___defaultcache");
    }
}

