/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.xsite.BaseCacheOperationsTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.NoTxDistCacheOperationsTest")
public class NoTxDistCacheOperationsTest
extends BaseCacheOperationsTest {
    @Override
    protected ConfigurationBuilder getNycActiveConfig() {
        return NoTxDistCacheOperationsTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
    }

    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        return NoTxDistCacheOperationsTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
    }

    public void testDataGetsReplicated() {
        this.cache("LON", 0).put((Object)"k_lon", (Object)"v_lon");
        AssertJUnit.assertNull((Object)this.cache("NYC", 0).get((Object)"k_lon"));
        AssertJUnit.assertEquals((Object)this.cache("LON", 1).get((Object)"k_lon"), (Object)"v_lon");
        AssertJUnit.assertEquals((Object)this.cache("NYC", "lonBackup", 0).get((Object)"k_lon"), (Object)"v_lon");
        AssertJUnit.assertEquals((Object)this.cache("NYC", "lonBackup", 1).get((Object)"k_lon"), (Object)"v_lon");
        this.cache("NYC", 1).put((Object)"k_nyc", (Object)"v_nyc");
        AssertJUnit.assertEquals((Object)this.cache("LON", 1).get((Object)"k_lon"), (Object)"v_lon");
        AssertJUnit.assertEquals((Object)this.cache("LON", "nycBackup", 0).get((Object)"k_nyc"), (Object)"v_nyc");
        AssertJUnit.assertEquals((Object)this.cache("LON", "nycBackup", 1).get((Object)"k_nyc"), (Object)"v_nyc");
        AssertJUnit.assertNull((Object)this.cache("LON", 0).get((Object)"k_nyc"));
        this.cache("LON", 1).remove((Object)"k_lon");
        AssertJUnit.assertNull((Object)this.cache("LON", 1).get((Object)"k_lon"));
        AssertJUnit.assertNull((Object)this.cache("NYC", "lonBackup", 0).get((Object)"k_lon"));
        AssertJUnit.assertNull((Object)this.cache("NYC", "lonBackup", 1).get((Object)"k_lon"));
    }
}

