/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.TakeOfflineConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.XSiteFileParsing3Test")
public class XSiteFileParsing3Test
extends SingleCacheManagerTest {
    public static final String FILE_NAME = "configs/xsite/xsite-offline-test.xml";

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager embeddedCacheManager = TestCacheManagerFactory.fromXml(FILE_NAME);
        return embeddedCacheManager;
    }

    public void testDefaultCache() {
        Configuration dcc = this.cacheManager.getDefaultCacheConfiguration();
        AssertJUnit.assertEquals((int)dcc.sites().allBackups().size(), (int)1);
        this.testDefault(dcc);
    }

    public void testInheritor() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("inheritor");
        this.testDefault(dcc);
    }

    public void testNoTakeOffline() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("noTakeOffline");
        AssertJUnit.assertEquals((int)1, (int)dcc.sites().allBackups().size());
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(new BackupConfiguration("NYC", BackupConfiguration.BackupStrategy.SYNC, 12003L, BackupFailurePolicy.WARN, null, false, new TakeOfflineConfiguration(0, 0L), true)));
        AssertJUnit.assertNull((Object)dcc.sites().backupFor().remoteSite());
        AssertJUnit.assertNull((Object)dcc.sites().backupFor().remoteCache());
    }

    public void testTakeOfflineDifferentConfig() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("takeOfflineDifferentConfig");
        AssertJUnit.assertEquals((int)1, (int)dcc.sites().allBackups().size());
        TakeOfflineConfiguration toc = new TakeOfflineConfiguration(321, 3765L);
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(new BackupConfiguration("NYC", BackupConfiguration.BackupStrategy.SYNC, 12003L, BackupFailurePolicy.IGNORE, null, false, toc, true)));
    }

    private void testDefault(Configuration dcc) {
        TakeOfflineConfiguration toc = new TakeOfflineConfiguration(123, 5673L);
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(new BackupConfiguration("NYC", BackupConfiguration.BackupStrategy.SYNC, 12003L, BackupFailurePolicy.IGNORE, null, false, toc, true)));
        AssertJUnit.assertEquals((String)"someCache", (String)dcc.sites().backupFor().remoteCache());
        AssertJUnit.assertEquals((String)"SFO", (String)dcc.sites().backupFor().remoteSite());
    }
}

