/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.backupfailure;

import org.infinispan.CacheException;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.xsite.AbstractTwoSitesTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"xsite"})
public abstract class BaseBackupFailureTest
extends AbstractTwoSitesTest {
    protected FailureInterceptor failureInterceptor;

    @Override
    protected void createSites() {
        super.createSites();
        this.failureInterceptor = new FailureInterceptor();
        this.backup("LON").getAdvancedCache().addInterceptor((CommandInterceptor)this.failureInterceptor, 1);
    }

    @BeforeMethod
    void resetFailureInterceptor() {
        this.failureInterceptor.reset();
    }

    protected boolean failOnBackupFailure(String site, int cacheIndex) {
        return ((BackupConfiguration)this.cache(site, cacheIndex).getCacheConfiguration().sites().allBackups().get(0)).backupFailurePolicy() == BackupFailurePolicy.FAIL;
    }

    public static class FailureInterceptor
    extends CommandInterceptor {
        protected volatile boolean isFailing = true;
        protected volatile boolean rollbackFailed;
        protected volatile boolean commitFailed;
        protected volatile boolean prepareFailed;
        protected volatile boolean putFailed;
        protected volatile boolean removeFailed;
        protected volatile boolean replaceFailed;
        protected volatile boolean clearFailed;
        protected volatile boolean putMapFailed;
        protected volatile boolean dontFailPrepare;

        public void reset() {
            this.rollbackFailed = false;
            this.commitFailed = false;
            this.prepareFailed = false;
            this.putFailed = false;
            this.removeFailed = false;
            this.removeFailed = false;
            this.clearFailed = false;
            this.putMapFailed = false;
            this.dontFailPrepare = false;
            this.isFailing = true;
        }

        public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
            if (this.isFailing) {
                this.rollbackFailed = true;
                throw new CacheException("Induced failure");
            }
            return this.invokeNextInterceptor((InvocationContext)ctx, (VisitableCommand)command);
        }

        public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
            if (this.isFailing) {
                this.commitFailed = true;
                throw new CacheException("Induced failure");
            }
            return this.invokeNextInterceptor((InvocationContext)ctx, (VisitableCommand)command);
        }

        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            if (this.isFailing && !this.dontFailPrepare) {
                this.prepareFailed = true;
                throw new CacheException("Induced failure");
            }
            return this.invokeNextInterceptor((InvocationContext)ctx, (VisitableCommand)command);
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            if (this.isFailing) {
                this.putFailed = true;
                throw new CacheException("Induced failure");
            }
            return this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        }

        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            if (this.isFailing) {
                this.removeFailed = true;
                throw new CacheException("Induced failure");
            }
            return this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        }

        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            if (this.isFailing) {
                this.replaceFailed = true;
                throw new CacheException("Induced failure");
            }
            return this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        }

        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            if (this.isFailing) {
                this.clearFailed = true;
                throw new CacheException("Induced failure");
            }
            return this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        }

        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            if (this.isFailing) {
                this.putMapFailed = true;
                throw new CacheException("Induced failure");
            }
            return this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        }

        public void disable() {
            this.isFailing = false;
        }

        public void enable() {
            this.isFailing = true;
        }

        public void dontFailPrepare() {
            this.dontFailPrepare = true;
        }
    }
}

