/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.List;
import java.util.Map;
import org.infinispan.CacheException;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.distribution.BaseDistributionInterceptor;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class NonTxDistributionInterceptor
extends BaseDistributionInterceptor {
    private static Log log = LogFactory.getLog(NonTxDistributionInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private boolean useLockForwarding;

    @Start
    public void start() {
        this.useLockForwarding = this.cacheConfiguration.locking().supportsConcurrentUpdates();
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        try {
            Object returnValue = this.invokeNextInterceptor(ctx, command);
            if (returnValue == null) {
                Object key = command.getKey();
                if (this.needsRemoteGet(ctx, command)) {
                    returnValue = this.remoteGet(ctx, key, command);
                }
                if (returnValue == null) {
                    returnValue = this.localGet(ctx, key, false, command);
                }
            }
            return returnValue;
        }
        catch (SuspectException e) {
            return this.visitGetKeyValueCommand(ctx, command);
        }
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        BaseDistributionInterceptor.SingleKeyRecipientGenerator skrg = new BaseDistributionInterceptor.SingleKeyRecipientGenerator(command.getKey());
        return this.handleWriteCommand(ctx, command, skrg, command.hasFlag(Flag.PUT_FOR_STATE_TRANSFER), false);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (ctx.isOriginLocal() && !this.isLocalModeForced(command)) {
            this.rpcManager.broadcastRpcCommand(command, this.isSynchronous(command));
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    protected Object handleWriteCommand(InvocationContext ctx, WriteCommand command, BaseDistributionInterceptor.RecipientGenerator recipientGenerator, boolean skipRemoteGet, boolean skipL1Invalidation) throws Throwable {
        this.remoteGetBeforeWrite(ctx, command, recipientGenerator);
        if (this.isLocalModeForced(command)) {
            return this.invokeNextInterceptor(ctx, command);
        }
        if (!ctx.isOriginLocal()) {
            Object returnValue = this.invokeNextInterceptor(ctx, command);
            this.handleRemoteWrite(ctx, command, recipientGenerator, skipL1Invalidation, this.isSynchronous(command));
            return returnValue;
        }
        return this.handleLocalWrite(ctx, command, recipientGenerator, skipL1Invalidation, this.isSynchronous(command));
    }

    protected void checkForOutdatedTopology(WriteCommand command) {
        if (!this.useLockForwarding) {
            return;
        }
        int commandTopologyId = command.getTopologyId();
        int currentTopologyId = this.stateTransferManager.getCacheTopology().getTopologyId();
        if (currentTopologyId != commandTopologyId && commandTopologyId != -1 && this.isSynchronous(command)) {
            log.tracef("Cache topology changed while the command was executing: expected %d, got %d", commandTopologyId, currentTopologyId);
            throw new OutdatedTopologyException("Cache topology changed while the command was executing: expected " + commandTopologyId + ", got " + currentTopologyId);
        }
    }

    private void remoteGetBeforeWrite(InvocationContext ctx, WriteCommand command, BaseDistributionInterceptor.KeyGenerator keygen) throws Throwable {
        if ((this.isNeedReliableReturnValues(command) || command.isConditional()) && !command.isIgnorePreviousValue()) {
            for (Object k : keygen.getKeys()) {
                Object returnValue = this.remoteGetBeforeWrite(ctx, k, command);
                if (returnValue != null || this.useLockForwarding && !this.cdl.localNodeIsPrimaryOwner(k)) continue;
                this.localGet(ctx, k, true, command);
            }
        }
    }

    private Object remoteGetBeforeWrite(InvocationContext ctx, Object key, FlagAffectedCommand command) throws Throwable {
        if (this.dm.isAffectedByRehash(key) && !this.dataContainer.containsKey(key)) {
            InternalCacheEntry ice;
            if (trace) {
                log.tracef("Doing a remote get for key %s", key);
            }
            if ((ice = this.retrieveFromRemoteSource(key, ctx, false, command)) != null) {
                if (!ctx.replaceValue(key, ice.getValue())) {
                    this.entryFactory.wrapEntryForPut(ctx, key, ice, false, command);
                }
                return ice.getValue();
            }
        } else if (trace) {
            log.tracef("Not doing a remote get for key %s since entry is not affected by rehash or is already in data container. We are %s, owners are %s", key, this.rpcManager.getAddress(), this.dm.locate(key));
        }
        return null;
    }

    private Object localGet(InvocationContext ctx, Object key, boolean isWrite, FlagAffectedCommand command) throws Throwable {
        InternalCacheEntry ice = this.dataContainer.get(key);
        if (ice != null) {
            if (!ctx.replaceValue(key, ice.getValue())) {
                if (isWrite) {
                    this.entryFactory.wrapEntryForPut(ctx, key, ice, false, command);
                } else {
                    ctx.putLookedUpEntry(key, ice);
                }
            }
            return command instanceof GetCacheEntryCommand ? ice : ice.getValue();
        }
        return null;
    }

    protected Object handleLocalWrite(InvocationContext ctx, WriteCommand command, BaseDistributionInterceptor.RecipientGenerator rg, boolean skipL1Invalidation, boolean sync) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (!this.isSingleOwnerAndLocal(rg)) {
            List<Address> recipients = rg.generateRecipients();
            if (!command.isSuccessful() && recipients.contains(this.rpcManager.getAddress())) {
                log.tracef("Skipping remote invocation as the command hasn't executed correctly on owner %s", this.rpcManager.getAddress());
            } else {
                Address primaryOwner;
                Map<Address, Response> responseMap = this.rpcManager.invokeRemotely(recipients, command, sync);
                if (sync && !recipients.isEmpty() && !(primaryOwner = recipients.get(0)).equals(this.rpcManager.getAddress())) {
                    returnValue = this.getResponseFromPrimaryOwner(primaryOwner, responseMap);
                }
            }
        }
        return returnValue;
    }

    protected void handleRemoteWrite(InvocationContext ctx, WriteCommand command, BaseDistributionInterceptor.RecipientGenerator recipientGenerator, boolean skipL1Invalidation, boolean sync) throws Throwable {
    }

    private Object remoteGet(InvocationContext ctx, Object key, GetKeyValueCommand command) throws Throwable {
        if (trace) {
            log.tracef("Doing a remote get for key %s", key);
        }
        InternalCacheEntry ice = this.retrieveFromRemoteSource(key, ctx, false, command);
        command.setRemotelyFetchedValue(ice);
        if (ice != null) {
            return ice.getValue();
        }
        return null;
    }

    protected Object getResponseFromPrimaryOwner(Address primaryOwner, Map<Address, Response> addressResponseMap) {
        Response fromPrimaryOwner = addressResponseMap.get(primaryOwner);
        if (fromPrimaryOwner == null) {
            log.tracef("Primary owner %s returned null", primaryOwner);
            return null;
        }
        if (!fromPrimaryOwner.isSuccessful()) {
            Exception cause = fromPrimaryOwner instanceof ExceptionResponse ? ((ExceptionResponse)fromPrimaryOwner).getException() : null;
            throw new CacheException("Got unsuccessful response from primary owner: " + fromPrimaryOwner, cause);
        }
        return ((SuccessfulResponse)fromPrimaryOwner).getResponseValue();
    }
}

