/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.affinity;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyAffinityServiceFactory;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.affinity.RndKeyGenerator;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="affinity.ConcurrentStartupTest")
public class ConcurrentStartupTest
extends AbstractCacheTest {
    public static final int KEY_QUEUE_SIZE = 100;
    EmbeddedCacheManager manager1 = null;
    EmbeddedCacheManager manager2 = null;
    AdvancedCache<Object, Object> cache1 = null;
    AdvancedCache<Object, Object> cache2 = null;
    KeyAffinityService<Object> keyAffinityService1 = null;
    KeyAffinityService<Object> keyAffinityService2 = null;
    private ExecutorService ex1;
    private ExecutorService ex2;

    @BeforeMethod
    protected void setUp() throws Exception {
        ConfigurationBuilder configurationBuilder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        configurationBuilder.transaction().invocationBatching().enable().clustering().cacheMode(CacheMode.DIST_SYNC).clustering().hash().numOwners(1).clustering().stateTransfer().fetchInMemoryState(false);
        this.manager1 = TestCacheManagerFactory.createClusteredCacheManager(configurationBuilder);
        this.manager1.defineConfiguration("test", configurationBuilder.build());
        this.cache1 = this.manager1.getCache("test").getAdvancedCache();
        this.ex1 = Executors.newSingleThreadExecutor();
        this.keyAffinityService1 = KeyAffinityServiceFactory.newLocalKeyAffinityService(this.cache1, (KeyGenerator)new RndKeyGenerator(), (Executor)this.ex1, (int)100);
        System.out.println("Address for manager1: " + this.manager1.getAddress());
        this.manager2 = TestCacheManagerFactory.createClusteredCacheManager(configurationBuilder);
        this.manager2.defineConfiguration("test", configurationBuilder.build());
        this.cache2 = this.manager2.getCache("test").getAdvancedCache();
        this.ex2 = Executors.newSingleThreadExecutor();
        this.keyAffinityService2 = KeyAffinityServiceFactory.newLocalKeyAffinityService(this.cache2, (KeyGenerator)new RndKeyGenerator(), (Executor)this.ex2, (int)100);
        System.out.println("Address for manager2: " + this.manager2.getAddress());
        TestingUtil.blockUntilViewsReceived(60000L, new Cache[]{this.cache1, this.cache2});
        Thread.sleep(5000L);
    }

    @AfterTest(alwaysRun=true)
    protected void tearDown() throws Exception {
        this.ex1.shutdownNow();
        this.ex2.shutdownNow();
        this.keyAffinityService1.stop();
        this.keyAffinityService2.stop();
        TestingUtil.killCacheManagers(this.manager1, this.manager2);
    }

    public void testKeyAffinityServiceFails() {
        Object keyForAddress;
        int i;
        System.out.println("Test keys for cache2.");
        for (i = 0; i < 100; ++i) {
            keyForAddress = this.keyAffinityService2.getKeyForAddress(this.manager2.getAddress());
            AssertJUnit.assertTrue((boolean)this.cache1.getDistributionManager().locate(keyForAddress).contains(this.manager2.getAddress()));
        }
        System.out.println("Test keys for cache1.");
        for (i = 0; i < 100; ++i) {
            keyForAddress = this.keyAffinityService1.getKeyForAddress(this.manager1.getAddress());
            List locate = this.cache1.getDistributionManager().locate(keyForAddress);
            AssertJUnit.assertTrue((String)("For key " + keyForAddress + " Locate " + locate + " should contain " + this.manager1.getAddress()), (boolean)locate.contains(this.manager1.getAddress()));
        }
    }
}

