/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.ConcurrentOperationsTest")
public class ConcurrentOperationsTest
extends MultipleCacheManagersTest {
    public static final int THREADS = 3;
    public static final int NUM_NODES = 3;
    public static final int OP_COUNT = 300;
    private static final boolean CONSOLE_ENABLED = false;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = ConcurrentOperationsTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        dcc.clustering().l1().disable();
        this.createClusteredCaches(3, dcc);
    }

    public void testNoTimeout() throws Throwable {
        this.runTest(false);
    }

    public void testNoTimeoutAndCorrectness() throws Throwable {
        this.runTest(true);
    }

    private void runTest(final boolean checkCorrectness) throws Throwable {
        final CyclicBarrier barrier = new CyclicBarrier(3);
        final Random rnd = new Random();
        final AtomicBoolean correctness = new AtomicBoolean(Boolean.TRUE);
        ArrayList<Future<Boolean>> result = new ArrayList<Future<Boolean>>();
        int t = 0;
        while (t < 3) {
            final int n = t++;
            Future<Boolean> f = this.fork(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    try {
                        for (int i = 0; i < 300; ++i) {
                            this.barrier();
                            this.executeOperation(i);
                            this.barrier();
                            this.checkCorrectness(i);
                            this.printProgress(i);
                            if (correctness.get()) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable t) {
                        correctness.set(false);
                        throw new Exception(t);
                    }
                    return correctness.get();
                }

                private void printProgress(int i) {
                    if (i % 100 == 0) {
                        ConcurrentOperationsTest.this.print("Progressing  = " + i);
                    }
                }

                private void executeOperation(int iteration) {
                    int node = rnd.nextInt(2);
                    switch (rnd.nextInt(4)) {
                        case 0: {
                            ConcurrentOperationsTest.this.cache(node).put((Object)"k", (Object)("v_" + n + "_" + iteration));
                            break;
                        }
                        case 1: {
                            ConcurrentOperationsTest.this.cache(node).remove((Object)"k");
                            break;
                        }
                        case 2: {
                            ConcurrentOperationsTest.this.cache(node).putIfAbsent((Object)"k", (Object)("v" + n));
                            break;
                        }
                        case 3: {
                            ConcurrentOperationsTest.this.cache(node).replace((Object)"k", (Object)("v" + n));
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }

                private void checkCorrectness(int i) {
                    if (checkCorrectness) {
                        boolean equals;
                        ConcurrentOperationsTest.this.log.tracef("Checking correctness for iteration %s", (Object)i);
                        ConcurrentOperationsTest.this.print("Checking correctness");
                        List owners = ConcurrentOperationsTest.this.advancedCache(0).getDistributionManager().locate((Object)"k");
                        assert (owners.size() == 2);
                        InternalCacheEntry entry0 = ConcurrentOperationsTest.this.advancedCache((Address)owners.get(0)).getDataContainer().get((Object)"k");
                        InternalCacheEntry entry1 = ConcurrentOperationsTest.this.advancedCache((Address)owners.get(1)).getDataContainer().get((Object)"k");
                        Object mainOwnerValue = entry0 == null ? null : entry0.getValue();
                        Object otherOwnerValue = entry1 == null ? null : entry1.getValue();
                        ConcurrentOperationsTest.this.log.tracef("Main owner value is %, other Owner Value is %s", mainOwnerValue, otherOwnerValue);
                        boolean bl = mainOwnerValue == null ? otherOwnerValue == null : (equals = mainOwnerValue.equals(otherOwnerValue));
                        if (!equals) {
                            ConcurrentOperationsTest.this.print("Consistency error. On main owner(" + owners.get(0) + ") we had " + mainOwnerValue + " and on backup owner(" + owners.get(1) + ") we had " + otherOwnerValue);
                            ConcurrentOperationsTest.this.log.trace((Object)("Consistency error. On main owner(" + owners.get(0) + ") we had " + mainOwnerValue + " and on backup owner(" + owners.get(1) + ") we had " + otherOwnerValue));
                            correctness.set(false);
                            return;
                        }
                        ConcurrentOperationsTest.this.print("otherOwnerValue = " + otherOwnerValue);
                        ConcurrentOperationsTest.this.print("mainOwnerValue = " + mainOwnerValue);
                        for (int q = 0; q < 3; ++q) {
                            ConcurrentOperationsTest.this.print(q, ConcurrentOperationsTest.this.cache(0).get((Object)"k"));
                        }
                        Object expectedValue = ConcurrentOperationsTest.this.cache(0).get((Object)"k");
                        ConcurrentOperationsTest.this.log.tracef("Original value read from cache 0 is %s", expectedValue);
                        for (int j = 0; j < 3; ++j) {
                            Object actualValue = ConcurrentOperationsTest.this.cache(j).get((Object)"k");
                            boolean areEquals = expectedValue == null ? actualValue == null : expectedValue.equals(actualValue);
                            ConcurrentOperationsTest.this.print("Are " + actualValue + " and " + expectedValue + " equals ? " + areEquals);
                            if (areEquals) continue;
                            correctness.set(false);
                            ConcurrentOperationsTest.this.print("Consistency error. On cache 0 we had " + expectedValue + " and on " + j + " we had " + actualValue);
                            ConcurrentOperationsTest.this.log.trace((Object)("Consistency error. On cache 0 we had " + expectedValue + " and on " + j + " we had " + actualValue));
                        }
                    }
                }

                private void barrier() throws BrokenBarrierException, TimeoutException, InterruptedException {
                    barrier.await(10000L, TimeUnit.MILLISECONDS);
                    ConcurrentOperationsTest.this.log.tracef("Just passed barrier.", new Object[0]);
                }
            });
            result.add(f);
        }
        for (Future future : result) {
            Assert.assertTrue((boolean)((Boolean)future.get()));
        }
    }

    private AdvancedCache advancedCache(Address address) {
        for (Cache c : this.caches()) {
            if (!c.getAdvancedCache().getRpcManager().getAddress().equals(address)) continue;
            return c.getAdvancedCache();
        }
        throw new IllegalStateException("Couldn't find cache for address : " + address);
    }

    private void print(int index, Object value) {
        this.print("[" + Thread.currentThread().getName() + "] Cache " + index + " sees value " + value);
    }

    private void print(Object value) {
    }

    public void testReplace() {
        this.cache(0).put((Object)"k", (Object)"v1");
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)"v1", (Object)this.cache(i).get((Object)"k"));
        }
        assert (this.cache(0).replace((Object)"k", (Object)"v2") != null);
        assert (this.cache(0).replace((Object)"k", (Object)"v2", (Object)"v3"));
        Assert.assertEquals((Object)this.cache(0).get((Object)"k"), (Object)"v3");
    }
}

