/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.lang.reflect.Method;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.SkipLockingTest")
public class SkipLockingTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createLocalCacheManager(false);
    }

    public void testSkipLockingAfterPutWithoutTm(Method m) {
        String name = m.getName();
        AdvancedCache advancedCache = this.cacheManager.getCache().getAdvancedCache();
        advancedCache.put((Object)("k-" + name), (Object)("v-" + name));
        advancedCache.withFlags(new Flag[]{Flag.SKIP_LOCKING}).put((Object)("k-" + name), (Object)("v2-" + name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSkipLockingAfterPutWithTm(Method m) {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createLocalCacheManager(true);
        try {
            AdvancedCache advancedCache = cacheManager.getCache().getAdvancedCache();
            String name = m.getName();
            advancedCache.put((Object)("k-" + name), (Object)("v-" + name));
            advancedCache.withFlags(new Flag[]{Flag.SKIP_LOCKING}).put((Object)("k-" + name), (Object)("v2-" + name));
        }
        finally {
            cacheManager.stop();
        }
    }
}

