/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.lifecycle.AbstractModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.StartCacheFromListenerTest")
public class StartCacheFromListenerTest
extends MultipleCacheManagersTest {
    final AtomicBoolean cacheStartingInvoked = new AtomicBoolean(false);

    @Override
    protected void createCacheManagers() throws Throwable {
        this.addClusterEnabledCacheManager();
        this.addClusterEnabledCacheManager();
        ConfigurationBuilder dcc = StartCacheFromListenerTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        this.manager(0).defineConfiguration("some", dcc.build());
        this.manager(0).defineConfiguration("cacheStarting", dcc.build());
        this.manager(0).defineConfiguration("cacheStarted", dcc.build());
    }

    public void testSingleInvocation() {
        final EmbeddedCacheManager cacheManager = this.manager(0);
        GlobalComponentRegistry registry = (GlobalComponentRegistry)TestingUtil.extractField(cacheManager, "globalComponentRegistry");
        LinkedList<1> lifecycles = new LinkedList<1>();
        TestingUtil.replaceField(lifecycles, "moduleLifecycles", registry, GlobalComponentRegistry.class);
        lifecycles.add(new AbstractModuleLifecycle(){

            public void cacheStarting(ComponentRegistry cr, Configuration configuration, String cacheName) {
                StartCacheFromListenerTest.this.log.debug((Object)"StartCacheFromListenerTest.cacheStarting");
                if (!StartCacheFromListenerTest.this.cacheStartingInvoked.get()) {
                    StartCacheFromListenerTest.this.cacheStartingInvoked.set(true);
                    Future fork = StartCacheFromListenerTest.this.fork(new Callable<Cache>(){

                        @Override
                        public Cache call() throws Exception {
                            try {
                                return cacheManager.getCache("cacheStarting");
                            }
                            catch (Exception e) {
                                StartCacheFromListenerTest.this.log.error((Object)"Got", (Throwable)e);
                                throw e;
                            }
                        }
                    });
                    try {
                        StartCacheFromListenerTest.this.log.debug((Object)"About to wait in get");
                        Cache cache = (Cache)fork.get();
                        cache.put((Object)"k", (Object)"v");
                        StartCacheFromListenerTest.this.log.debug((Object)"returned from get!");
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.log.debug((Object)"StartCacheFromListenerTest.testSingleInvocation1");
        Cache some = cacheManager.getCache("some");
        this.log.debug((Object)"StartCacheFromListenerTest.testSingleInvocation2");
        some.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((Object)"v", (Object)cacheManager.getCache("cacheStarting").get((Object)"k"));
    }
}

