/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.batch;

import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.api.batch.AbstractBatchTest;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransactionSetup;
import org.infinispan.transaction.TransactionMode;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"}, testName="api.batch.BatchWithTMTest")
public class BatchWithTMTest
extends AbstractBatchTest {
    EmbeddedCacheManager cm;

    @BeforeClass
    public void createCacheManager() {
        this.cm = TestCacheManagerFactory.createLocalCacheManager(false);
    }

    @AfterClass(alwaysRun=true)
    public void destroyCacheManager() {
        TestingUtil.killCacheManagers(this.cm);
        this.cm = null;
    }

    public void testBatchWithOngoingTM() throws Exception {
        Cache<String, String> cache = null;
        cache = this.createCache("testBatchWithOngoingTM");
        TransactionManager tm = TestingUtil.getTransactionManager(cache);
        tm.begin();
        cache.put((Object)"k", (Object)"v");
        cache.startBatch();
        cache.put((Object)"k2", (Object)"v2");
        tm.commit();
        assert ("v".equals(cache.get((Object)"k")));
        assert ("v2".equals(cache.get((Object)"k2")));
        cache.endBatch(false);
        assert ("v".equals(cache.get((Object)"k")));
        assert ("v2".equals(cache.get((Object)"k2")));
    }

    public void testBatchWithoutOngoingTMSuspension() throws Exception {
        Cache<String, String> cache = this.createCache("testBatchWithoutOngoingTMSuspension");
        TransactionManager tm = TestingUtil.getTransactionManager(cache);
        assert (tm.getTransaction() == null) : "Should have no ongoing txs";
        cache.startBatch();
        cache.put((Object)"k", (Object)"v");
        assert (tm.getTransaction() == null) : "Should have no ongoing txs";
        cache.put((Object)"k2", (Object)"v2");
        assert (this.getOnDifferentThread(cache, "k") == null);
        assert (this.getOnDifferentThread(cache, "k2") == null);
        try {
            tm.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        assert (tm.getTransaction() == null) : "Should have no ongoing txs";
        assert (this.getOnDifferentThread(cache, "k") == null);
        assert (this.getOnDifferentThread(cache, "k2") == null);
        cache.endBatch(true);
        assert ("v".equals(this.getOnDifferentThread(cache, "k")));
        assert ("v2".equals(this.getOnDifferentThread(cache, "k2")));
    }

    public void testBatchRollback() throws Exception {
        Cache<String, String> cache = this.createCache("testBatchRollback");
        cache.startBatch();
        cache.put((Object)"k", (Object)"v");
        cache.put((Object)"k2", (Object)"v2");
        Assert.assertEquals((String)this.getOnDifferentThread(cache, "k"), null);
        assert (this.getOnDifferentThread(cache, "k2") == null);
        cache.endBatch(false);
        assert (this.getOnDifferentThread(cache, "k") == null);
        assert (this.getOnDifferentThread(cache, "k2") == null);
    }

    private Cache<String, String> createCache(String name) {
        Configuration c = new Configuration();
        c.setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        c.setInvocationBatchingEnabled(true);
        c.fluent().transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        assert (c.getTransactionManagerLookupClass() != null) : "Should have a transaction manager lookup class attached!!";
        this.cm.defineConfiguration(name, c);
        return this.cm.getCache(name);
    }
}

