/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.flags;

import java.lang.reflect.Method;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.api.flags.FlagsEnabledTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.distribution.MagicKey;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.UnnnecessaryLoadingTest;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.flags.NonTxFlagsEnabledTest")
@CleanupAfterMethod
public class NonTxFlagsEnabledTest
extends FlagsEnabledTest {
    @Override
    public void testReplicateSkipCacheLoaderWithinTxInCoordinator(Method m) throws Exception {
    }

    @Override
    public void testReplicateSkipCacheLoaderWithinTxInNonCoordinator(Method m) throws Exception {
    }

    public void testCacheLocalInNonOwner() {
        this.addClusterEnabledCacheManager(this.getConfigurationBuilder());
        this.waitForClusterToForm("replication");
        AdvancedCache cache1 = this.advancedCache(0, "replication");
        AdvancedCache cache2 = this.advancedCache(1, "replication");
        AdvancedCache cache3 = this.advancedCache(2, "replication");
        MagicKey key = new MagicKey("k-no", (Cache<?, ?>)cache1);
        cache3.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)key, (Object)"value");
        AssertJUnit.assertEquals((String)("Cache '" + cache3 + "' should have the key."), (String)"value", (String)((String)cache3.get((Object)key)));
        AssertJUnit.assertNull((String)("Cache '" + cache1 + "' should *not* have the key."), (Object)cache1.get((Object)key));
        AssertJUnit.assertNull((String)("Cache '" + cache2 + "' should *not* have the key."), (Object)cache2.get((Object)key));
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = NonTxFlagsEnabledTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
        builder.loaders().addStore().cacheStore((CacheStore)new UnnnecessaryLoadingTest.CountingCacheStore()).loaders().addStore().cacheStore((CacheStore)new DummyInMemoryCacheStore()).clustering().hash().numSegments(2);
        this.createClusteredCaches(2, "replication", builder);
    }

    private ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder builder = NonTxFlagsEnabledTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
        builder.loaders().addStore().cacheStore((CacheStore)new UnnnecessaryLoadingTest.CountingCacheStore()).loaders().addStore().cacheStore((CacheStore)new DummyInMemoryCacheStore()).clustering().hash().numSegments(2);
        return builder;
    }
}

