/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.ValueFuture;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="atomic.AtomicHashMapPessimisticConcurrencyTest")
public class AtomicHashMapPessimisticConcurrencyTest
extends SingleCacheManagerTest {
    private static final Log log = LogFactory.getLog(AtomicHashMapPessimisticConcurrencyTest.class);
    public static final String KEY = "key";
    private LockingMode lockingMode = LockingMode.PESSIMISTIC;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        builder.locking().lockAcquisitionTimeout(1000L);
        builder.invocationBatching().enable();
        builder.transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).lockingMode(this.lockingMode);
        return TestCacheManagerFactory.createCacheManager(builder);
    }

    public void testConcurrentCreate() throws Exception {
        this.tm().begin();
        AtomicMapLookup.getAtomicMap((Cache)this.cache, (Object)KEY);
        final AtomicBoolean gotTimeoutException = new AtomicBoolean();
        this.fork(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AtomicHashMapPessimisticConcurrencyTest.this.tm().begin();
                    try {
                        AtomicMapLookup.getAtomicMap((Cache)AtomicHashMapPessimisticConcurrencyTest.this.cache, (Object)AtomicHashMapPessimisticConcurrencyTest.KEY);
                    }
                    catch (TimeoutException e) {
                        gotTimeoutException.set(true);
                    }
                    finally {
                        AtomicHashMapPessimisticConcurrencyTest.this.tm().rollback();
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Unexpected error performing transaction", (Throwable)e);
                }
            }
        }, true);
        assert (gotTimeoutException.get());
    }

    public void testLockTimeout() throws Exception {
        AtomicMap atomicMap = AtomicMapLookup.getAtomicMap((Cache)this.cache, (Object)KEY);
        this.tm().begin();
        atomicMap.put((Object)1, (Object)"");
        Future<Object> future = this.fork(new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                AtomicHashMapPessimisticConcurrencyTest.this.tm().begin();
                try {
                    AtomicMap otMap = AtomicMapLookup.getAtomicMap((Cache)AtomicHashMapPessimisticConcurrencyTest.this.cache, (Object)AtomicHashMapPessimisticConcurrencyTest.KEY);
                    otMap.put((Object)1, (Object)"val");
                }
                finally {
                    AtomicHashMapPessimisticConcurrencyTest.this.tm().rollback();
                }
                return null;
            }
        });
        try {
            future.get(10L, TimeUnit.SECONDS);
            Assert.fail((String)"Should have failed with a TimeoutException");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TimeoutException));
        }
    }

    public void testConcurrentPut() throws Exception {
        final CountDownLatch readLatch = new CountDownLatch(1);
        final CountDownLatch commitLatch = new CountDownLatch(1);
        AtomicMap atomicMap = AtomicMapLookup.getAtomicMap((Cache)this.cache, (Object)KEY);
        this.tm().begin();
        atomicMap.put((Object)1, (Object)"value1");
        Future<Object> future = this.fork(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    AtomicHashMapPessimisticConcurrencyTest.this.tm().begin();
                    AtomicMap otMap = AtomicMapLookup.getAtomicMap((Cache)AtomicHashMapPessimisticConcurrencyTest.this.cache, (Object)AtomicHashMapPessimisticConcurrencyTest.KEY);
                    Assert.assertEquals((int)otMap.size(), (int)0);
                    readLatch.countDown();
                    otMap.put((Object)2, (Object)"value2");
                    commitLatch.await(10L, TimeUnit.SECONDS);
                    AtomicHashMapPessimisticConcurrencyTest.this.tm().commit();
                }
                catch (Exception e) {
                    AtomicHashMapPessimisticConcurrencyTest.this.tm().rollback();
                    throw e;
                }
                return null;
            }
        });
        readLatch.await(10L, TimeUnit.SECONDS);
        this.tm().commit();
        commitLatch.countDown();
        future.get(10L, TimeUnit.SECONDS);
        Assert.assertEquals((Set)atomicMap.keySet(), new HashSet<Integer>(Arrays.asList(1, 2)));
    }

    public void testConcurrentRemove() throws Exception {
        final CountDownLatch readLatch = new CountDownLatch(1);
        final CountDownLatch commitLatch = new CountDownLatch(1);
        AtomicMap atomicMap = AtomicMapLookup.getAtomicMap((Cache)this.cache, (Object)KEY);
        this.tm().begin();
        atomicMap.put((Object)1, (Object)"value1");
        atomicMap.put((Object)2, (Object)"value2");
        atomicMap.put((Object)3, (Object)"value3");
        this.tm().commit();
        this.tm().begin();
        atomicMap.remove((Object)1);
        Future<Object> future = this.fork(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    AtomicHashMapPessimisticConcurrencyTest.this.tm().begin();
                    AtomicMap otMap = AtomicMapLookup.getAtomicMap((Cache)AtomicHashMapPessimisticConcurrencyTest.this.cache, (Object)AtomicHashMapPessimisticConcurrencyTest.KEY);
                    Assert.assertEquals((int)otMap.size(), (int)3);
                    readLatch.countDown();
                    otMap.remove((Object)2);
                    commitLatch.await(10L, TimeUnit.SECONDS);
                    AtomicHashMapPessimisticConcurrencyTest.this.tm().commit();
                }
                catch (Exception e) {
                    AtomicHashMapPessimisticConcurrencyTest.this.tm().rollback();
                    throw e;
                }
                return null;
            }
        });
        readLatch.await(10L, TimeUnit.SECONDS);
        this.tm().commit();
        commitLatch.countDown();
        future.get(10L, TimeUnit.SECONDS);
        Assert.assertEquals((Set)atomicMap.keySet(), new HashSet<Integer>(Arrays.asList(3)));
    }

    public void testReadAfterTxStarted() throws Exception {
        AtomicMap atomicMap = AtomicMapLookup.getAtomicMap((Cache)this.cache, (Object)KEY);
        atomicMap.put((Object)1, (Object)"existing");
        this.tm().begin();
        atomicMap.put((Object)1, (Object)"newVal");
        final ValueFuture responseBeforeCommit = new ValueFuture();
        final ValueFuture responseAfterCommit = new ValueFuture();
        final CountDownLatch commitLatch = new CountDownLatch(1);
        Future<Object> future = this.fork(new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                AtomicHashMapPessimisticConcurrencyTest.this.tm().begin();
                try {
                    AtomicMap otMap = AtomicMapLookup.getAtomicMap((Cache)AtomicHashMapPessimisticConcurrencyTest.this.cache, (Object)AtomicHashMapPessimisticConcurrencyTest.KEY);
                    responseBeforeCommit.set(otMap.get((Object)1));
                    commitLatch.await();
                    responseAfterCommit.set(otMap.get((Object)1));
                }
                finally {
                    AtomicHashMapPessimisticConcurrencyTest.this.tm().rollback();
                }
                return null;
            }
        });
        Assert.assertEquals(responseBeforeCommit.get(), (Object)"existing");
        this.tm().commit();
        commitLatch.countDown();
        future.get(10L, TimeUnit.SECONDS);
        Assert.assertEquals((String)((String)atomicMap.get((Object)1)), (String)"newVal");
        Assert.assertEquals(responseAfterCommit.get(), (Object)"newVal");
    }
}

