/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="atomic.AtomicMapFunctionalTest")
public class AtomicMapFunctionalTest
extends SingleCacheManagerTest {
    private static final Log log = LogFactory.getLog(AtomicMapFunctionalTest.class);

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = this.buildConfiguration();
        return TestCacheManagerFactory.createCacheManager(builder);
    }

    protected ConfigurationBuilder buildConfiguration() {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        builder.invocationBatching().enable();
        builder.transaction().lockingMode(LockingMode.OPTIMISTIC);
        return builder;
    }

    public void testChangesOnAtomicMap() {
        AtomicMap map = AtomicMapLookup.getAtomicMap((Cache)this.cache, (Object)"key");
        assert (map.isEmpty());
        map.put((Object)"a", (Object)"b");
        assert (((String)map.get((Object)"a")).equals("b"));
        assert (AtomicMapLookup.getAtomicMap((Cache)this.cache, (Object)"key").get((Object)"a").equals("b"));
    }

    public void testTxChangesOnAtomicMap() throws Exception {
        AtomicMap map = AtomicMapLookup.getAtomicMap((Cache)this.cache, (Object)"key");
        this.tm().begin();
        assert (map.isEmpty());
        map.put((Object)"a", (Object)"b");
        assert (((String)map.get((Object)"a")).equals("b"));
        Transaction t = this.tm().suspend();
        assert (AtomicMapLookup.getAtomicMap((Cache)this.cache, (Object)"key").get((Object)"a") == null);
        this.tm().resume(t);
        this.tm().commit();
        assert (AtomicMapLookup.getAtomicMap((Cache)this.cache, (Object)"key").get((Object)"a").equals("b"));
    }

    public void testChangesOnAtomicMapNoLocks() {
        AtomicMap map = AtomicMapLookup.getAtomicMap((Cache)this.cache, (Object)"key");
        assert (map.isEmpty());
        log.debug((Object)"Doing a put");
        map.put((Object)"a", (Object)"b");
        log.debug((Object)"Put complete");
        assert (((String)map.get((Object)"a")).equals("b"));
        assert (AtomicMapLookup.getAtomicMap((Cache)this.cache, (Object)"key").get((Object)"a").equals("b"));
    }

    public void testTxChangesOnAtomicMapNoLocks() throws Exception {
        AtomicMap map = AtomicMapLookup.getAtomicMap((Cache)this.cache, (Object)"key");
        this.tm().begin();
        assert (map.isEmpty());
        map.put((Object)"a", (Object)"b");
        assert (((String)map.get((Object)"a")).equals("b"));
        Transaction t = this.tm().suspend();
        assert (AtomicMapLookup.getAtomicMap((Cache)this.cache, (Object)"key").get((Object)"a") == null);
        this.tm().resume(t);
        this.tm().commit();
        assert (AtomicMapLookup.getAtomicMap((Cache)this.cache, (Object)"key").get((Object)"a").equals("b"));
    }

    public void testChangesOnAtomicMapNoLocksExistingData() {
        AtomicMap map = AtomicMapLookup.getAtomicMap((Cache)this.cache, (Object)"key");
        assert (map.isEmpty());
        map.put((Object)"x", (Object)"y");
        assert (((String)map.get((Object)"x")).equals("y"));
        log.debug((Object)"Doing a put");
        map.put((Object)"a", (Object)"b");
        log.debug((Object)"Put complete");
        assert (((String)map.get((Object)"a")).equals("b"));
        assert (((String)map.get((Object)"x")).equals("y"));
        assert (AtomicMapLookup.getAtomicMap((Cache)this.cache, (Object)"key").get((Object)"x").equals("y"));
        assert (AtomicMapLookup.getAtomicMap((Cache)this.cache, (Object)"key").get((Object)"a").equals("b"));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testRemovalOfAtomicMap() throws SystemException, NotSupportedException, RollbackException, HeuristicRollbackException, HeuristicMixedException {
        AtomicMap map = AtomicMapLookup.getAtomicMap((Cache)this.cache, (Object)"key");
        map.put((Object)"hello", (Object)"world");
        TransactionManager tm = this.cache.getAdvancedCache().getTransactionManager();
        tm.begin();
        map = AtomicMapLookup.getAtomicMap((Cache)this.cache, (Object)"key");
        map.put((Object)"hello2", (Object)"world2");
        assert (map.size() == 2);
        AtomicMapLookup.removeAtomicMap((Cache)this.cache, (Object)"key");
        map.size();
        tm.commit();
    }
}

